package com.xforceplus.xplat.epcp.sdk.infrastructure.http;

import com.xforceplus.xplat.epcp.sdk.base.BaseComponent;
import okhttp3.Request;
import okhttp3.Response;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import reactor.core.publisher.Mono;

import java.util.Map;
import java.util.function.Function;

/**
 * TODO
 */
public interface HttpInterceptor extends BaseComponent {

    @Override
    default String kind() {
        return "http-interceptor";
    }

    /**
     * deal request
     *
     * @param request
     * @param localContext
     * @return
     */
    Request doWithRequest(Request request, Map<String, Object> localContext);

    /**
     * deal response
     *
     * @param response
     * @param localContext
     * @return
     */
    Response doWithResponse(Response response, Map<String, Object> localContext);


    /**
     * webclient related interceptor
     *
     * @return
     */
    Function<ClientRequest, Mono<ClientRequest>> requestProcessor(Map<String, Object> localContext);

    /**
     * webclient related interceptor
     *
     * @param localContext
     * @return
     */
    Function<ClientResponse, Mono<ClientResponse>> responseProcessor(Map<String, Object> localContext);

}
