package com.xforceplus.xplat.epcp.sdk.infrastructure.http.webclient;

import com.xforceplus.xplat.epcp.sdk.infrastructure.http.HttpInterceptor;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.publisher.Mono;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class WebClientFilterWrapper implements ExchangeFilterFunction {

    private HttpInterceptor httpInterceptor;

    public WebClientFilterWrapper(HttpInterceptor httpInterceptor) {
        this.httpInterceptor = httpInterceptor;
    }

    @Override
    public Mono<ClientResponse> filter(ClientRequest request, ExchangeFunction next) {
        Map<String, Object> contextMap = new HashMap<>();
        Function<ClientRequest, Mono<ClientRequest>> processor = httpInterceptor.requestProcessor(contextMap);
        Function<ClientResponse, Mono<ClientResponse>> clientResponseMonoFunction = httpInterceptor.responseProcessor(contextMap);
        //todo-rayder 2.2.14
        return processor.apply(request).flatMap(next::exchange);//.share().flatMap(clientResponseMonoFunction);
    }
}
