package com.xforceplus.xplat.epcp.sdk.infrastructure.plugin.extension;


import com.xforceplus.xplat.epcp.sdk.base.anno.OnScene;

import java.lang.annotation.*;

/**
 * Extension
 * 只能使用在扩展点实现的类上，不能使用在扩展点定义上面
 *
 * @author mumutu
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE})
@Inherited
@Documented
public @interface XExtension {

    /**
     * 扩展点实现的唯一标识Code
     */
    String value();

    /**
     * 场景匹配
     */
    OnScene[] scenes() default {};

    /**
     * 是否是默认实现逻辑，只能声明一个默认逻辑，如果有多个会默认取找到的第一个实现，顺序暂时不可控
     */
    boolean isDefault() default false;
}
