package com.xforceplus.xplat.epcp.sdk.infrastructure.plugin.extension.dynamic;

import org.apache.commons.io.IOUtils;
import org.stringtemplate.v4.ST;

import javax.annotation.processing.FilerException;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;

public class DefaultExtensionStorage extends XExtensionStorage {

    private String template;

    public DefaultExtensionStorage(XExtensionAnnotationProcessor processor) {
        super(processor);
        try {
            InputStream resourceAsStream = getClass().getResourceAsStream("/".concat(TEMPLATE_PATH));
            template = IOUtils.toString(resourceAsStream, StandardCharsets.UTF_8);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map<String, Set<NameClassPair>> read() {
        return null;
    }

    private void writeFile(String extension, String className, String extensionName) {
        try {
            FileObject file = getFiler().createResource(StandardLocation.CLASS_OUTPUT, ""
                    , EXTENSIONS_RESOURCE.concat(extension).concat("_").concat(extensionName).concat(".yaml"));
            try (BufferedWriter writer = new BufferedWriter(file.openWriter())) {
                writer.write("# Generated by XPLAT"); // write header
                writer.newLine();
                ST st = new ST(template);
                st.add("name", extensionName);
                st.add("className", className);
                st.add("extensionPoint", extension);
                st.add("enabled", true);
                writer.write(st.render());
            }
        } catch (FileNotFoundException e) {
            // it's the first time, create the file
        } catch (FilerException e) {
            // re-opening the file for reading or after writing is ignorable
        } catch (IOException e) {
            error(e.toString());
        }
    }

    @Override
    public void write(Map<String, Set<NameClassPair>> extensions) {

        extensions.forEach((k, v) -> {
            String extensionName = k;
            Set<NameClassPair> nameClassPairs = v;
            v.forEach(nameClassPair -> {
                writeFile(extensionName, nameClassPair.getClassName(), nameClassPair.getKey());
            });
        });


    }
}