package com.xforceplus.xplat.epcp.sdk.infrastructure.plugin.extension.dynamic;

import java.util.Objects;

public class NameClassPair implements Comparable<NameClassPair>{

    private String key;

    private String className;

    public NameClassPair(String key, String className) {
        this.key = key;
        this.className = className;
    }

    public String getKey() {
        return key;
    }

    public String getClassName() {
        return className;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        NameClassPair that = (NameClassPair) o;
        return Objects.equals(key, that.key) && Objects.equals(className, that.className);
    }

    @Override
    public int hashCode() {
        return Objects.hash(key, className);
    }

    @Override
    public int compareTo(NameClassPair o) {
        return key.compareTo(o.key);
    }
}
