package com.xforceplus.xplat.epcp.sdk.infrastructure.plugin.extension.dynamic;

import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class XExtensionStorage {

    public static final String EXTENSIONS_RESOURCE = "META-INF/extensions/";

    public static final String TEMPLATE_PATH = "ExtensionTemplate.yaml";

    private static final Pattern COMMENT = Pattern.compile("#.*");
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");

    protected final XExtensionAnnotationProcessor processor;

    public XExtensionStorage(XExtensionAnnotationProcessor processor) {
        this.processor = processor;
    }

    public abstract Map<String, Set<NameClassPair>> read();

    public abstract void write(Map<String, Set<NameClassPair>> extensions);

    protected Filer getFiler() {
        return processor.getProcessingEnvironment().getFiler();
    }

    protected void error(String message, Object... args) {
        processor.error(message, args);
    }

    protected void error(Element element, String message, Object... args) {
        processor.error(element, message, args);
    }

    protected void info(String message, Object... args) {
        processor.info(message, args);
    }

    protected void info(Element element, String message, Object... args) {
        processor.info(element, message, args);
    }
}