package com.xforceplus.xplat.epcp.sdk.infrastructure.plugin.extension.dynamic;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
import com.xforceplus.xplat.epcp.sdk.metadata.spec.Metadata;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ResourceList;
import io.github.classgraph.ScanResult;
import org.pf4j.AbstractExtensionFinder;
import org.pf4j.PluginManager;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.net.URI;
import java.util.*;
import java.util.stream.Collectors;

public class XLegacyExtensionFinder extends AbstractExtensionFinder {

    private Logger log = LoggerFactory.getLogger(XLegacyExtensionFinder.class);

    private YAMLMapper mapper = new YAMLMapper();

    /**
     * TODO
     */
    public static final String EXTENSIONS_RESOURCE = XExtensionStorage.EXTENSIONS_RESOURCE;

    public XLegacyExtensionFinder(PluginManager pluginManager) {
        super(pluginManager);
    }

    /**
     * has no plugin
     *
     * @return
     */
    @Override
    public Map<String, Set<String>> readClasspathStorages() {
        log.debug("Reading extensions storages from classpath");
        // pluginId,Set<ClassName>
        Map<String, Set<String>> result = new LinkedHashMap<>();


        Set<String> bucket;
        ClassGraph classGraph = new ClassGraph();
        try(ScanResult scan = classGraph.enableAllInfo()
                .acceptPaths(XExtensionStorage.EXTENSIONS_RESOURCE).scan()) {
            try(ResourceList resourcesWithExtension = scan.getResourcesWithExtension(".yaml")) {
                bucket = resourcesWithExtension.stream().map(resource -> {
                    try {
                        String contentAsString = resource.getContentAsString();
                        JsonNode jsonNode = mapper.readTree(contentAsString);
                        JsonNode extract = jsonNode.get("spec").get("metadata");
                        Metadata metadata = new Metadata(mapper.writeValueAsString(extract));
                        Boolean enabled = metadata.getBool("enabled");
                        if (enabled) {
                            String className = metadata.getString("className");
                            return className;
                        }
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                    return null;
                }).filter(Objects::nonNull).collect(Collectors.toSet());

                debugExtensions(bucket);

                result.put(null, bucket);
            } catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        }

        return result;
    }

    /**
     * TODO
     *
     * @return
     */
    @Override
    public Map<String, Set<String>> readPluginsStorages() {
        log.debug("Reading extensions storages from plugins");
        Map<String, Set<String>> result = new LinkedHashMap<>();

        List<PluginWrapper> plugins = pluginManager.getPlugins();

        if(plugins.isEmpty()) {
            return Collections.emptyMap();
        }

        ClassGraph classGraph = new ClassGraph();
        /**
         * should remove the temporaryFiles then the plugin can be removed
         */
        List<ClassLoader> classLoaders = new ArrayList<>();
        Map<URI, String> pluginMapping = new HashMap<>();
        for (PluginWrapper plugin : plugins) {

            String pluginId = plugin.getDescriptor().getPluginId();
            pluginMapping.put(plugin.getPluginPath().toUri(), pluginId);
            log.debug("Reading extensions storage from plugin '{}'", pluginId);

            try {
                log.debug("Read '{}'", EXTENSIONS_RESOURCE);
                ClassLoader pluginClassLoader = plugin.getPluginClassLoader();
                classLoaders.add(pluginClassLoader);
            } catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        }

        try(ScanResult scan = classGraph.ignoreParentClassLoaders().overrideClassLoaders(classLoaders.toArray(new ClassLoader[]{})).
                acceptPaths(XExtensionStorage.EXTENSIONS_RESOURCE).scan()) {
            ResourceList resourcesWithExtensionInJars = scan.getResourcesWithExtension(".yaml");
            ResourceList filter = resourcesWithExtensionInJars.filter(x -> x.getClasspathElementURL().toExternalForm().endsWith(".jar"));

            filter.stream().forEach(resource -> {
                try {
                    URI classpathElementURI = resource.getClasspathElementURI();
                    Optional<URI> first = pluginMapping.keySet().stream().filter(x -> classpathElementURI.relativize(x).toString().equals("")).findFirst();
                    String pluginId = null;
                    if (first.isPresent()) {
                        pluginId = pluginMapping.get(first.get());
                    }
                    if (pluginId != null) {
                        String contentAsString = resource.getContentAsString();
                        JsonNode jsonNode = mapper.readTree(contentAsString);
                        JsonNode extract = jsonNode.get("spec").get("metadata");
                        Metadata metadata = new Metadata(mapper.writeValueAsString(extract));
                        Boolean enabled = metadata.getBool("enabled");
                        if (enabled) {
                            String className = metadata.getString("className");
                            result.compute(pluginId, (k, v) -> {
                                if (v == null) {
                                    v = new HashSet<>();
                                }
                                v.add(className);
                                return v;
                            });
                        }
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                }
            });

            try {
                resourcesWithExtensionInJars.close();

            } catch (Exception ex) {
                //should close here
                log.warn("{}", ex);
            }
        }

        return result;
    }
}
