//package com.xforceplus.tech.infrastructure.plugin.extension.listener;
//
//import com.fasterxml.jackson.core.JsonProcessingException;
//import com.fasterxml.jackson.databind.JsonNode;
//import com.fasterxml.jackson.dataformat.yaml.YAMLMapper;
//import com.xforceplus.tech.infrastructure.plugin.extension.update.UpdateManager;
//import com.xforceplus.tech.metadata.runtime.ConfigEventListener;
//import com.xforceplus.tech.metadata.runtime.event.ConfigChangedEvent;
//import com.xforceplus.tech.metadata.spec.Metadata;
//import com.xforceplus.ultraman.config.event.ChangeList;
//import com.xforceplus.ultraman.config.json.JsonConfigNode;
//import org.apache.commons.lang3.StringUtils;
//import org.pf4j.PluginManager;
//import org.pf4j.PluginState;
//import org.pf4j.PluginWrapper;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//
//import java.util.Optional;
//
//public class PluginConfigListener implements ConfigEventListener {
//
//    private final UpdateManager updateManager;
//
//    private final YAMLMapper yamlMapper;
//
//    private Logger log = LoggerFactory.getLogger(PluginConfigListener.class);
//
//    public PluginConfigListener(UpdateManager pluginManager, YAMLMapper yamlMapper) {
//        this.updateManager = pluginManager;
//        this.yamlMapper = yamlMapper;
//    }
//
//    /**
//     * static
//     *
//     * @return
//     */
//    @Override
//    public String[] types() {
//        return new String[]{"plugin"};
//    }
//
//    @Override
//    public void onConfigChanged(ConfigChangedEvent configChangedEvent) {
//        ChangeList<JsonConfigNode> changeList = configChangedEvent.getChangeList();
//        JsonConfigNode current = changeList.getCurrent();
//        //new
//        JsonNode origin = current.getOrigin();
//        JsonNode spec = origin.get("spec");
//        JsonNode action = spec.get("action");
//        JsonNode name = origin.get("metadata").get("name");
//        if(action != null && action.asText().equals("remove")) {
//            removePlugin(name.asText());
//        } else {
//            JsonNode metadataNode = spec.get("metadata");
//            handlePlugin(current.id(), metadataNode);
//        }
//    }
//
//    private void removePlugin(String pluginId){
//        updateManager.uninstallPlugin(pluginId);
//    }
//
//    private void handlePlugin(String id, JsonNode metadataNode) {
//
//        try {
//            String configStr = yamlMapper.writeValueAsString(metadataNode);
//            Metadata metadata = new Metadata(configStr);
//            String pluginId = metadata.getString("plugin-id");
//            String pluginVersion = metadata.getString("plugin-version");
//            boolean enabled = metadata.getBool("enabled");
//
//            PluginManager pluginManager = updateManager.getPluginManager();
//            PluginWrapper plugin = pluginManager.getPlugin(pluginId);
//            if (!enabled) {
//                if (plugin != null) {
//                    pluginManager.unloadPlugin(pluginId);
//                }
//                return;
//            } else {
//                if (plugin != null && plugin.getDescriptor().getVersion().equals(pluginVersion)) {
//                    if (plugin.getPluginState() != PluginState.STARTED) {
//                        pluginManager.startPlugin(pluginId);
//                    }
//                } else {
//                    if (StringUtils.isEmpty(pluginId) || StringUtils.isEmpty(pluginVersion)) {
//                        log.warn("plugin {} format error missing required plugin-id or plugin-version", id);
//                    } else {
//                        try {
//                            boolean hasInstalled;
//                            if(plugin != null) {
//                                hasInstalled  = updateManager.updatePlugin(pluginId, pluginVersion);
//                            } else {
//                                hasInstalled = updateManager.installPlugin(pluginId, pluginVersion);
//                            }
//                            if (hasInstalled) {
//                                log.info("plugin {} installed", id);
//                            } else {
//                                log.error("plugin {} install failed", id);
//                            }
//                        } catch (Exception ex) {
//                            log.error("{}", ex);
//                        }
//                    }
//                }
//            }
//        } catch (JsonProcessingException e) {
//            throw new RuntimeException(e);
//        }
//    }
//}
