//package com.xforceplus.tech.infrastructure.plugin.extension.update;
//
//import java.net.URL;
//import java.util.Map;
//
//public interface UpdateRepository {
//
//    /**
//     * @return the ID of this repository. This must be unique
//     */
//    String getId();
//
//    /**
//     * @return the URL of this repository as a String
//     */
//    URL getUrl();
//
//    /**
//     * Get all plugin information for this repository.
//     *
//     * @return Map of PluginId and PluginInfo
//     */
//    Map<String, PluginDetailInfo> getPlugins();
//
//    /**
//     * Get a particular plugin information from this repository.
//     *
//     * @param id the id of the plugin
//     * @return the PluginInfo
//     */
//    PluginDetailInfo getPlugin(String id);
//
//    /**
//     * Flushes cached info to force re-fetching repository state on next get.
//     */
//    void refresh();
//
//    /**
//     * Each repository has the option of overriding the download process.
//     * They can e.g. do checksum, signature verifications etc.
//     * To use the default downloader, return null.
//     *
//     * @return the FileDownloader to use for this repository or null if you do not wish to override
//     */
//    FileDownloader getFileDownloader();
//
//    /**
//     * Gets a file verifier to execute on the downloaded file for it to be claimed valid.
//     * Maybe a CompoundVerifier in order to chain several verifiers.
//     *
//     * @return {@link FileVerifier}
//     */
//    FileVerifier getFileVerifier();
//
//}
