//package com.xforceplus.tech.infrastructure.plugin.extension.update.repository;
//
//import com.xforceplus.tech.infrastructure.plugin.extension.update.FileDownloader;
//import org.pf4j.PluginRuntimeException;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//
//import java.io.IOException;
//import java.net.URISyntaxException;
//import java.net.URL;
//import java.nio.file.Files;
//import java.nio.file.Path;
//
//public class NexusFileDownloader implements FileDownloader {
//
//    private static final Logger log = LoggerFactory.getLogger(NexusFileDownloader.class);
//
//    private NexusRepository.NexusService nexusService;
//
//    public NexusFileDownloader(NexusRepository.NexusService nexusService) {
//        this.nexusService = nexusService;
//    }
//
//    /**
//     * @param fileUrl the URI representing the file to download
//     * @return the path of downloaded/copied file
//     * @throws IOException in case of network or IO problems
//     * @throws PluginRuntimeException in case of other problems
//     */
//    public Path downloadFile(String fileUrl) throws IOException {
//        return downloadFileHttp(fileUrl);
//    }
//
//    /**
//     * Downloads file from HTTP or FTP.
//     *
//     * @param fileUrl source file
//     * @return path of downloaded file
//     * @throws IOException if IO problems
//     * @throws PluginRuntimeException if validation fails or any other problems
//     */
//    protected Path downloadFileHttp(String fileUrl) throws IOException {
//        Path destination = Files.createTempDirectory("xplat-update-downloader");
//        destination.toFile().deleteOnExit();
//
//        String fileName = fileUrl.substring(fileUrl.lastIndexOf('/') + 1);
//        Path file = destination.resolve(fileName);
//
//        try {
//            nexusService.download(fileUrl, file);
//        } catch (URISyntaxException e) {
//            e.printStackTrace();
//        }
//
//        return file;
//    }
//
//}
