//package com.xforceplus.tech.infrastructure.plugin.extension.update.repository;
//
//import com.fasterxml.jackson.databind.JsonNode;
//import com.fasterxml.jackson.databind.node.ArrayNode;
//import com.fasterxml.jackson.dataformat.xml.XmlMapper;
//import com.typesafe.config.ConfigFactory;
//import com.xforceplus.tech.infrastructure.http.HttpComponent;
//import com.xforceplus.tech.infrastructure.plugin.extension.update.*;
//import com.xforceplus.tech.metadata.spec.Metadata;
//import io.vavr.Tuple;
//import io.vavr.Tuple2;
//import org.apache.commons.lang3.StringUtils;
//import org.apache.maven.model.Model;
//import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.core.io.buffer.DataBuffer;
//import org.springframework.core.io.buffer.DataBufferUtils;
//import org.springframework.http.HttpHeaders;
//import org.springframework.http.ResponseEntity;
//import reactor.core.publisher.Flux;
//import reactor.core.publisher.Mono;
//
//import java.io.ByteArrayInputStream;
//import java.net.URISyntaxException;
//import java.net.URL;
//import java.nio.file.Path;
//import java.nio.file.StandardOpenOption;
//import java.time.Instant;
//import java.time.LocalDateTime;
//import java.time.ZoneId;
//import java.time.ZonedDateTime;
//import java.time.format.DateTimeFormatter;
//import java.util.*;
//import java.util.stream.Collectors;
//
///**
// * nexus repository
// */
//public class NexusRepository implements UpdateRepository {
//
//    private String id;
//
//    private URL baseUrl;
//
//    private String groupName;
//
//    private Map<String, PluginDetailInfo> plugins = new HashMap<>();
//
//    private NexusService nexusService;
//
//    public NexusRepository(String id, URL baseUrl, String groupName) {
//        this.id = id;
//        this.baseUrl = baseUrl;
//        this.groupName = groupName;
//        this.nexusService = new NexusService(baseUrl.toExternalForm());
//    }
//
//    @Override
//    public String getId() {
//        return id;
//    }
//
//    @Override
//    public URL getUrl() {
//        return baseUrl;
//    }
//
//    @Override
//    public Map<String, PluginDetailInfo> getPlugins() {
//        if (plugins.isEmpty()) {
//            init();
//        }
//
//        return Collections.unmodifiableMap(plugins);
//    }
//
//    /**
//     * read plugin from nexus
//     * list all
//     */
//    private void init() {
//        List<RepositorySearchDTO> searchDTOS = nexusService.searchPlugin(groupName, baseUrl.toExternalForm());
//        List<PluginDetailInfo> details = searchDTOS.stream().map(x -> {
//            PluginDetailInfo detailInfo = nexusService.getDetailInfo( x);
//            return detailInfo;
//        }).filter(Objects::nonNull).collect(Collectors.toList());
//
//        Map<String, Optional<PluginDetailInfo>> groupMapping = details.stream().collect(Collectors.groupingBy(x -> x.getId(), Collectors.reducing((a, b) -> {
//            List<PluginDetailInfo.PluginRelease> releases = a.getReleases();
//            if (releases instanceof ArrayList) {
//                releases.addAll(b.getReleases());
//            } else {
//                releases = new ArrayList<>(releases);
//                releases.addAll(b.getReleases());
//            }
//
//            a.setReleases(releases);
//            return a;
//        })));
//
//        groupMapping.forEach((id, pluginDetailInfoOp) -> {
//            if (pluginDetailInfoOp.isPresent()) {
//                PluginDetailInfo pluginDetailInfo = pluginDetailInfoOp.get();
//                pluginDetailInfo.setRepositoryId(getId());
//                plugins.put(id, pluginDetailInfo);
//            }
//        });
//    }
//
////    private List<>
//
//    @Override
//    public PluginDetailInfo getPlugin(String id) {
//        return getPlugins().get(id);
//    }
//
//    @Override
//    public void refresh() {
//        //refresh thread
//        plugins.clear();
//    }
//
//    @Override
//    public FileDownloader getFileDownloader() {
//        return new NexusFileDownloader(nexusService);
//    }
//
//    @Override
//    public FileVerifier getFileVerifier() {
//        return null;
//    }
//
//    /**
//     * nexus service
//     */
//    public static class NexusService {
//
//        private HttpComponent httpComponent = new DefaultHttp();
//
//        private XmlMapper xmlMapper = new XmlMapper();
//
//        private String context = "nexus/service/local/lucene/search";
//
//        private String repositoryContext = "nexus/content/repositories/plugins";
//
//        private String artifactContentContext = "nexus/service/local/artifact/maven/content";
//
//        private String artifactMetadataContext = "nexus/service/local/artifact/maven/resolve";
//
//        private String POM_TEMPLATE = "%s-%s.pom";
//
//        private Logger logger = LoggerFactory.getLogger(NexusService.class);
//
//        private DateTimeFormatter dtf = DateTimeFormatter.ofPattern("E, d MMM u H:m:s z", Locale.ENGLISH);
//
//        private String baseUrl;
//
//        public NexusService(String baseUrl) {
//            httpComponent.init(new Metadata(ConfigFactory.empty()));
//            this.baseUrl = baseUrl;
//        }
//
//        private RepositorySearchDTO jsonNodeToDto(JsonNode node) {
//            JsonNode groupId = node.get("groupId");
//            JsonNode artifactId = node.get("artifactId");
//            JsonNode version = node.get("version");
//            JsonNode latestRelease = node.get("latestRelease");
//            RepositorySearchDTO repositorySearchDTO = new RepositorySearchDTO();
//            repositorySearchDTO.setGa(Tuple.of(groupId.asText(), artifactId.asText()));
//            repositorySearchDTO.setVersion(version.asText());
//            repositorySearchDTO.setLatestRelease(latestRelease.asText());
//            return repositorySearchDTO;
//        }
//
//        /**
//         * head
//         * https://nexus.xforceplus.com/nexus/service/local/artifact/maven/content?g=org.example&a=DemoPlugin&v=RELEASE
//         *
//         * @param groupId
//         * @param artifactId
//         * @param version
//         * @return
//         */
//        private String getReleaseTime(String groupId, String artifactId, String version) {
//            try {
//                Mono<ResponseEntity<Void>> responseEntity = httpComponent.getClient().head()
//                        .uri(baseUrl, uriBuilder -> {
//                            return uriBuilder
//                                    .path(artifactContentContext)
//                                    .queryParam("g", groupId)
//                                    .queryParam("a", artifactId)
//                                    .queryParam("v", version)
//                                    .queryParam("r", "plugins")
//                                    .build();
//                        }).retrieve().toBodilessEntity();
//
//                HttpHeaders headers = responseEntity.block().getHeaders();
//                List<String> lastModifyTime = headers.get("last-modified");
//                if (!lastModifyTime.isEmpty()) {
//                    return lastModifyTime.get(0);
//                } else {
//                    return null;
//                }
//            } catch (Exception ex) {
//                logger.warn("{}", ex);
//                return null;
//            }
//        }
//
//        public void download(String url, Path path) throws URISyntaxException {
//            Flux<DataBuffer> dataBufferFlux = httpComponent.getClient().get()
//                    .uri(baseUrl, uriBuilder -> {
//                        return uriBuilder
//                                .path(repositoryContext)
//                                .path(url).build();
//                    })
//                    .retrieve().bodyToFlux(DataBuffer.class);
//            DataBufferUtils.write(dataBufferFlux, path, StandardOpenOption.CREATE).block();
//        }
//
//        public PluginDetailInfo.PluginRelease getRelease(String groupId, String artifactId, String version) {
//            try {
//
//                String releaseTime = getReleaseTime(groupId, artifactId, version);
//                String metadataContent = httpComponent.getClient().get()
//                        .uri(baseUrl, uriBuilder -> {
//                            return uriBuilder
//                                    .path(artifactMetadataContext)
//                                    .queryParam("g", groupId)
//                                    .queryParam("a", artifactId)
//                                    .queryParam("v", version)
//                                    .queryParam("r", "plugins")
//                                    .build();
//                        }).retrieve().bodyToMono(String.class).block();
//
//                JsonNode metadataNode = xmlMapper.readTree(metadataContent);
//                JsonNode data = metadataNode.get("data");
//                JsonNode sha1 = data.get("sha1");
//                JsonNode releaseStr = data.get("version");
//                JsonNode url = data.get("repositoryPath");
//
//                PluginDetailInfo.PluginRelease release = new PluginDetailInfo.PluginRelease();
//                release.sha512sum = sha1.asText();
//                if (!StringUtils.isEmpty(releaseTime)) {
//                    ZonedDateTime parse = ZonedDateTime.parse(releaseTime, dtf);
//                    Instant instant = parse.toInstant();
//                    release.date = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
//                }
//
//                release.version = releaseStr.asText();
//                release.url = url.asText();
//                return release;
//            } catch (Exception ex) {
//                logger.warn("{}", ex);
//                return null;
//            }
//        }
//
//        /**
//         * http://nexus.xforceplus.com/nexus/content/repositories/plugins/org/example/DemoPlugin/1.2-RELEASE/DemoPlugin-1.2-RELEASE.pom
//         *
//         * @param searchDTO
//         * @return
//         */
//        public PluginDetailInfo getDetailInfo(RepositorySearchDTO searchDTO) {
//            String group = searchDTO.getGa()._1();
//            String artifact = searchDTO.getGa()._2();
//            String finalContext = group.replaceAll("\\.", "/");
//            String version = searchDTO.version;
//
//            try {
//                String pom = httpComponent.getClient().get()
//                        .uri(baseUrl, uriBuilder -> {
//                            return uriBuilder
//                                    .path(repositoryContext)
//                                    .pathSegment(finalContext, artifact, version, String.format(POM_TEMPLATE, artifact, version))
//                                    .build();
//                        }).retrieve()
//                        .bodyToMono(String.class)
//                        .block();
//
//                MavenXpp3Reader reader = new MavenXpp3Reader();
//                Model pluginOp = reader.read(new ByteArrayInputStream(pom.getBytes()));
//                Properties properties = pluginOp.getProperties();
//                /**
//                 *         <plugin.id>custom-plugin</plugin.id>
//                 *         <plugin.class>org.example.CQPPlugin</plugin.class>
//                 *         <plugin.version>0.0.1</plugin.version>
//                 *         <plugin.provider>mumutu</plugin.provider>
//                 *         <plugin.dependencies />
//                 */
//                String pluginId = properties.getProperty("plugin.id");
//                String pluginClass = properties.getProperty("plugin.class");
//                String pluginVersion = properties.getProperty("plugin.version");
//                if (StringUtils.isNoneEmpty(pluginId)
//                        && StringUtils.isNoneEmpty(pluginClass)
//                        && StringUtils.isNoneEmpty(pluginVersion)) {
//                    //this is a plugin
//                    PluginDetailInfo pluginDetailInfo = new PluginDetailInfo();
//                    pluginDetailInfo.setId(pluginId);
//
//                    String description = pluginOp.getDescription();
//                    String provider = properties.getProperty("plugin.provider");
//                    /**
//                     * TODO
//                     */
//                    pluginDetailInfo.setProjectUrl(pluginOp.getUrl());
//                    pluginDetailInfo.setDescription(description);
//                    pluginDetailInfo.setProvider(provider);
//                    //construct the release
//                    PluginDetailInfo.PluginRelease release = getRelease(group, artifact, version);
//                    if (release != null) {
//                        //TODO
//                        if(pluginVersion.equals("${project.version}")) {
//                            pluginVersion = pluginOp.getVersion();
//                        }
//                        release.version = pluginVersion;
//                        pluginDetailInfo.setReleases(Collections.singletonList(release));
//                    }
//                    return pluginDetailInfo;
//                } else {
//                    return null;
//                }
//            } catch (Exception ex) {
//                logger.warn("skip due to {}", ex);
//                return null;
//            }
//        }
//
//        public List<RepositorySearchDTO> searchPlugin(String groupName, String baseUrl) {
//            Map<String, String> queryPart = new HashMap<>();
//            queryPart.put("g", groupName);
//            queryPart.put("repositoryId", "plugins");
//            String responseContent = httpComponent.getClient().get()
//                    .uri(baseUrl, uriBuilder -> {
//                        uriBuilder
//                                .path(context)
//                                .queryParam("g", groupName)
//                                .queryParam("repositoryId", "plugins");
//                        return uriBuilder.build();
//                    })
//                    .retrieve().bodyToMono(String.class).block();
//
//
//            try {
//                JsonNode jsonNode = xmlMapper.readTree(responseContent);
//                JsonNode data = jsonNode.get("data");
//                JsonNode artifact = data.get("artifact");
//                if (artifact instanceof ArrayNode) {
//                    List<RepositorySearchDTO> searchDTOS = new ArrayList<>();
//                    artifact.forEach(node -> {
//                        try {
//                            RepositorySearchDTO repositorySearchDTO = jsonNodeToDto(node);
//                            searchDTOS.add(repositorySearchDTO);
//                        } catch (Throwable ex) {
//                            logger.warn("{}", ex);
//                        }
//                    });
//                    return searchDTOS;
//                } else {
//                    RepositorySearchDTO repositorySearchDTO = jsonNodeToDto(artifact);
//                    return Collections.singletonList(repositorySearchDTO);
//                }
//
//            } catch (Exception ex) {
//                logger.warn("{}", ex);
//                return Collections.emptyList();
//            }
//        }
//    }
//
//    /**
//     * System.out.println(node.get("groupId"));
//     * System.out.println(node.get("artifactId"));
//     * System.out.println(node.get("version"));
//     * System.out.println(node.get("latestRelease"));
//     */
//
//    public static class RepositorySearchDTO {
//        private Tuple2<String, String> ga;
//        private String version;
//        private String latestRelease;
//
//        public Tuple2<String, String> getGa() {
//            return ga;
//        }
//
//        public void setGa(Tuple2<String, String> ga) {
//            this.ga = ga;
//        }
//
//        public String getVersion() {
//            return version;
//        }
//
//        public void setVersion(String version) {
//            this.version = version;
//        }
//
//        public String getLatestRelease() {
//            return latestRelease;
//        }
//
//        public void setLatestRelease(String latestRelease) {
//            this.latestRelease = latestRelease;
//        }
//    }
//}
