//package com.xforceplus.tech.infrastructure.plugin.extension.update.verifier;
//
//import com.xforceplus.tech.infrastructure.plugin.extension.update.FileVerifier;
//import VerifyException;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.util.DigestUtils;
//
//import java.io.BufferedReader;
//import java.io.IOException;
//import java.io.InputStreamReader;
//import java.lang.invoke.MethodHandles;
//import java.math.BigInteger;
//import java.net.URL;
//import java.nio.file.Files;
//import java.nio.file.Path;
//import java.security.MessageDigest;
//
//public class ShaVerifier implements FileVerifier {
//
//    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
//
//    @Override
//    public void verify(Context context, Path file) throws VerifyException, IOException {
//        String expectedShaSum;
//        if (context.sha1 == null) {
//            log.debug("No sha512 checksum specified, skipping verification");
//            return;
//        } else {
//            expectedShaSum = context.sha1;
//        }
//
//        log.debug("Verifying sha1 checksum of file {}", file.getFileName());
//        String actualSha1sum = "";
//        try {
//            MessageDigest digest = MessageDigest.getInstance("SHA-1");
//            digest.reset();
//            digest.update(Files.readAllBytes(file));
//            actualSha1sum = String.format("%040x", new BigInteger(1, digest.digest()));
//
//            if (actualSha1sum.equalsIgnoreCase(expectedShaSum)) {
//                log.debug("Checksum OK");
//                return;
//            }
//        } catch (Exception ex) {
//            throw new VerifyException(ex.getMessage());
//        }
//        throw new VerifyException("SHA1 checksum of downloaded file " + file.getFileName()
//                + " does not match that from plugin descriptor. Got " + actualSha1sum
//                + " but expected " + expectedShaSum);
//    }
//
//    private String getUrlContents(String url) throws IOException {
//        try (BufferedReader reader = new BufferedReader(new InputStreamReader(
//                new URL(url).openStream()))) {
//            return reader.readLine();
//        }
//    }
//}
