package com.xforceplus.xplat.epcp.sdk.spring;

import com.xforceplus.xplat.epcp.sdk.base.BaseComponent;
import com.xforceplus.xplat.epcp.sdk.base.BaseComponentRegistry;
import com.xforceplus.xplat.epcp.sdk.base.RegistryAware;
import com.xforceplus.xplat.epcp.sdk.base.trait.PreInitAware;
import com.xforceplus.xplat.epcp.sdk.base.trait.PreInitConsumer;
import com.xforceplus.xplat.epcp.sdk.metadata.spec.Metadata;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

/**
 * Component factory bean
 */
public class ComponentFactoryBean extends AbstractFactoryBean<BaseComponent> implements ApplicationContextAware {

    private Metadata metadata;

    private ApplicationContext applicationContext;

    private Class componentClass;

    private String name;

    @Autowired
    private List<PreInitConsumer> consumerList;

    private BaseComponentRegistry registry;

    public List<PreInitConsumer> getConsumerList() {
        return consumerList;
    }

    public void setConsumerList(List<PreInitConsumer> consumerList) {
        this.consumerList = consumerList;
    }

    public Metadata getMetadata() {
        return metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class getComponentClass() {
        return componentClass;
    }

    public void setComponentClass(Class componentClass) {
        this.componentClass = componentClass;
    }

    public BaseComponentRegistry getRegistry() {
        return registry;
    }

    public void setRegistry(BaseComponentRegistry registry) {
        this.registry = registry;
    }

    @Override
    public Class<?> getObjectType() {
        return componentClass;
    }

    @Override
    protected BaseComponent createInstance() throws Exception {
        BaseComponent componentObj = (BaseComponent) componentClass.newInstance();
        componentObj.name(name);

        applicationContext
                .getAutowireCapableBeanFactory()
                .autowireBean(componentObj);

        if (componentObj instanceof RegistryAware) {
            ((RegistryAware) componentObj).setRegistry(registry);
        }

        if (componentObj instanceof PreInitAware) {
            Optional.ofNullable(consumerList).orElseGet(Collections::emptyList).forEach(x -> {
                ((PreInitAware)componentObj).preInit(x);
            });
        }

        componentObj.init(metadata);

        return componentObj;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
