package com.xforceplus.xplat.epcp.sdk.spring.api.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.xplat.epcp.sdk.context.route.CommonResponse;
import com.xforceplus.xplat.epcp.sdk.context.route.RouteInfo;
import com.xforceplus.xplat.epcp.sdk.spring.api.UserCenterGatewayApiService;
import com.xforceplus.xplat.epcp.sdk.spring.api.vo.AuthTplVo;
import com.xforceplus.xplat.epcp.sdk.spring.config.RouteConfiguration;
import com.xplat.ultraman.api.management.pojo.auth.AuthContentPlaceType;
import com.xplat.ultraman.api.management.pojo.auth.AuthTemplateType;
import com.xplat.ultraman.api.management.pojo.enums.Method;
import com.xplat.ultraman.api.management.restclient.agent.executor.AgentExecutor;
import com.xplat.ultraman.api.management.restclient.dto.AgentClient;
import com.xplat.ultraman.api.management.restclient.dto.AuthTemplate;
import com.xplat.ultraman.api.management.restclient.rest.ParameterTypeReference;
import okhttp3.*;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * epcp-sdk
 *
 * @Author 👽 zhaolei
 * @Date 📅 2022/9/14 18:20
 * @Motto: Tools change the world. 🛠
 * @Copyright: xforceplus 🇨🇳
 * @Description: 用户中心网关接口服务，通过网关调用后端服务
 */
@Service
public class UserCenterGatewayApiServiceImpl implements UserCenterGatewayApiService {

    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private AgentExecutor restAgentExecutor;

    @Autowired
    private RouteConfiguration routeConfiguration;

    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public Map routeQuery(List<String> epList) throws Exception {
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("epList", epList);
        params.put("appId", routeConfiguration.getAppId());
        params.put("env", routeConfiguration.getEnvId());

        if (!StringUtils.isEmpty(routeConfiguration.getLocalEpcpUrl())) {
            return routeQueryLocal(params);
        }

        log.debug("获取扩展点路由配置");
        String apiPath = "/global/epcp/v1/ep/route/query";
        AuthTplVo authIplVo = AuthTplVo.builder().templateCode("usercenter").env(routeConfiguration.getUserCenterEnv()).build();

        AgentClient agentClient = new AgentClient
                .AgentClientBuilder<CommonResponse<Map<String, List<RouteInfo>>>>(getAuthTemplate(authIplVo), apiPath)
                .method(Method.POST)
                .body(params)
                .parameterTypeReference(new ParameterTypeReference<CommonResponse<Map<String, List<RouteInfo>>>>() {
                })
                .builder();

        CommonResponse<Map<String, List<RouteInfo>>> response = (CommonResponse<Map<String, List<RouteInfo>>>) restAgentExecutor.execute(agentClient);
        if (CommonResponse.SUCCESSFUL_CODE == response.getCode()) {
            return response.getResult();
        } else {
            throw new Exception(response.getMessage());
        }
    }

    private AuthTemplate getAuthTemplate(AuthTplVo authTpl) {
        return new AuthTemplate(authTpl.getEnv(), authTpl.getTemplateCode(), AuthTemplateType.JWT_AUTH, AuthContentPlaceType.LOCAl);
    }


    /**
     * 本地接口调用测试
     *
     * @throws Exception
     */
    private Map routeQueryLocal(Map params) throws Exception {
        OkHttpClient client = new OkHttpClient().newBuilder()
                .build();
        MediaType mediaType = MediaType.parse("application/json");
        RequestBody body = RequestBody.create(mediaType, objectMapper.writeValueAsString(params));

        Request request = new Request.Builder()
                .url(routeConfiguration.getLocalEpcpUrl() + "/v1/ep/route/query")
                .method("POST", body)
                .addHeader("Content-Type", "application/json")
                .build();
        Response response = client.newCall(request).execute();
        String responseBody = response.body().string();
        if (response.isSuccessful()) {
            CommonResponse<Map<String, List<RouteInfo>>> result = objectMapper.readValue(responseBody,
                    new TypeReference<CommonResponse<Map<String, List<RouteInfo>>>>() {
                    });
            if (CommonResponse.SUCCESSFUL_CODE == result.getCode()) {
                return result.getResult();
            } else {
                throw new Exception(result.getMessage());
            }
        } else {
            throw new Exception("routeQueryLocal error." + response.code() + "-" + responseBody);
        }

    }
}
