package com.xforceplus.xplat.epcp.sdk.spring.dispatcher.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.xplat.epcp.sdk.context.ContextService;
import com.xforceplus.xplat.epcp.sdk.infrastructure.plugin.extension.XExtension;
import com.xforceplus.xplat.epcp.sdk.infrastructure.plugin.extension.XExtensionDefinition;
import com.xforceplus.xplat.epcp.sdk.infrastructure.plugin.extension.XExtensionModule;
import com.xforceplus.xplat.epcp.sdk.infrastructure.plugin.extension.XExtensionPoint;
import com.xforceplus.xplat.epcp.sdk.spring.dispatcher.ExtentionServiceDispatcher;
import io.github.classgraph.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ReflectionUtils;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * epcp-sdk
 *
 * @Author 👽 zhaolei
 * @Date 📅 2022/10/11 15:20
 * @Motto: Tools change the world. 🛠
 * @Copyright: xforceplus 🇨🇳
 * @Description:
 */
public class ExtentionServiceDispatcherImpl implements ExtentionServiceDispatcher {
    @Autowired
    private final ApplicationContext applicationContext;

    @Autowired
    private final ContextService contextService;

    private final ObjectMapper objectMapper;

    public ExtentionServiceDispatcherImpl(ApplicationContext applicationContext, ContextService contextService) {
        this.applicationContext = applicationContext;
        this.contextService = contextService;
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public Object invokeEp(Class epClass, Object... args) {
        return null;
    }

    @Override
    public Object invokeEp(String epCode, Object... args) {
        return null;
    }

    @Override
    public Object invokeEpImpl(String epImplCode, Object... args) {

        ClassInfo epImplClassInfo = getEpImplClassInfo(epImplCode);

        Method implMethod = getImplMethod(epImplClassInfo);

        List<Object> params = convertParams(implMethod, args);

        Object result = ReflectionUtils.invokeMethod(implMethod, applicationContext.getBean(epImplClassInfo.loadClass()), params.toArray());

        return result;
    }

    private List<Object> convertParams(Method implMethod, Object... args) {
        List<Object> params = new ArrayList<>();
        for (int i = 0; i < implMethod.getParameterTypes().length; i++) {
            Class parameterType = implMethod.getParameterTypes()[i];
            Object param = objectMapper.convertValue(args[i], parameterType);
            params.add(param);
        }
        return params;
    }

    private Method getImplMethod(ClassInfo epImplClassInfo) {
        Optional<ClassInfo> parentClassOptional = epImplClassInfo.getInterfaces().stream().filter(epImplClassInfoItem -> {
            if (epImplClassInfoItem.hasAnnotation(XExtensionDefinition.class)) {
                return true;
            }

            return false;
        }).findFirst();
        if (!parentClassOptional.isPresent()) {
            throw new RuntimeException("未找到扩展点定义接口类");
        }
        MethodInfoList parentMethodInfo = parentClassOptional.get().getDeclaredMethodInfo();
        if (parentMethodInfo.size() == 0) {
            throw new RuntimeException("未找到扩展点定义方法");
        }
        // 默认取第一个方法
        MethodInfo methodInfo = parentMethodInfo.get(0);
        MethodInfo implMethodInfo = epImplClassInfo.getMethodInfo().getSingleMethod(methodInfo.getName());
        Method implMethod = implMethodInfo.loadClassAndGetMethod();
        return implMethod;
    }

    private ClassInfo getEpImplClassInfo(String epImplCode) {
        ScanResult scan = new ClassGraph().disableJarScanning().enableAllInfo().scan();

        // 扫描扩展点和本机扩展实现
        ClassInfoList xExtensionPointClassList = scan.getClassesImplementing(XExtensionPoint.class);

        String finalEpImplCode = epImplCode;
        Optional<ClassInfo> epImplClassOptional = xExtensionPointClassList.stream().filter(xExtentionPointClassItem -> {
            // 扩展实现
            if (!xExtentionPointClassItem.hasAnnotation(XExtension.class)) {
                return false;
            }
            // 判断 如果是扩展模块则跳过
            if (xExtentionPointClassItem.getClass().equals(XExtensionModule.class)) {
                return false;
            }
            String epImplCodeEach = xExtentionPointClassItem.getAnnotationInfo(XExtension.class).getParameterValues().get("value").getValue() + "";
            if (epImplCodeEach.equals(finalEpImplCode)) {
                return true;
            }
            return false;
        }).findFirst();
        if (!epImplClassOptional.isPresent()) {
            throw new RuntimeException("未匹配到扩展点实现");
        }

        ClassInfo epImplClassInfo = epImplClassOptional.get();
        return epImplClassInfo;
    }
}
