//package com.xforceplus.tech.spring.endpoint;
//
//import com.xforceplus.xplat.epcp.base.BaseComponentRegistry;
//import com.xforceplus.xplat.epcp.base.binding.*;
//import com.xforceplus.xplat.epcp.base.binding.exception.BindingInvokingException;
//import com.xforceplus.xplat.epcp.base.binding.exception.BindingNotFoundException;
//import com.xforceplus.xplat.epcp.base.binding.exception.BindingOperationMissingException;
//import com.xforceplus.xplat.epcp.base.binding.exception.BindingOperationNotAcceptableException;
//import io.vavr.control.Either;
//import org.apache.commons.lang3.StringUtils;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.http.MediaType;
//import org.springframework.web.bind.annotation.*;
//import reactor.core.publisher.Mono;
//
//import javax.servlet.http.HttpServletResponse;
//import java.io.IOException;
//import java.io.PrintWriter;
//import java.nio.charset.StandardCharsets;
//import java.util.List;
//import java.util.Map;
//import java.util.Optional;
//import java.util.stream.Stream;
//
///**
// * unifier endpoint
// */
//@RequestMapping("/v1/bindings")
//public class BindingController {
//
//    @Autowired
//    private BindingClient bindingClient;
//
//    @PostMapping("/{bindingName}")
//    @ResponseBody
//    public void bindingEndpoint(@PathVariable String bindingName, @RequestBody UnifierDTO unifierDTO, HttpServletResponse response) {
//
//        response.setContentType(MediaType.TEXT_PLAIN_VALUE + ";charset=UTF-8");
//        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
//        PrintWriter writer = null;
//        try {
//            writer = response.getWriter();
//        } catch (IOException e) {
//            e.printStackTrace();
//        }
//
//        try {
//            String operation = unifierDTO.getOperation();
//            Object data = unifierDTO.getData();
//            Map<String, Object> metadata = unifierDTO.getMetadata();
//            Mono<OutputBindingResponse> result = bindingClient.invokeMethod(bindingName, operation, data, metadata);
//            OutputBindingResponse outputResponse = result.block();
//
//            Map<String, String> metadataResponse = outputResponse.getMetadata();
//            UnifierResponse unifierResponse = new UnifierResponse();
//            unifierResponse.setData(outputResponse.getData());
//            unifierResponse.setMetadata(metadata);
//            response.setContentType(MediaType.APPLICATION_JSON_VALUE + ";charset=UTF-8");
//
//            List<String> contentType = outputResponse.getContentType();
//            byte[] dataResponse = outputResponse.getData();
//            Object finalResponse;
//            if (contentType.contains(MediaType.APPLICATION_JSON_VALUE.toLowerCase()) || contentType.contains(MediaType.TEXT_PLAIN_VALUE.toLowerCase())) {
//                finalResponse = new String(dataResponse, StandardCharsets.UTF_8);
//            } else {
//                finalResponse = dataResponse;
//            }
//        } catch (Exception e) {
//            if (e instanceof BindingOperationMissingException) {
//                response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
//            } else if (e instanceof BindingNotFoundException) {
//                response.setStatus(HttpServletResponse.SC_NOT_FOUND);
//            } else if (e instanceof BindingOperationNotAcceptableException) {
//                response.setStatus(HttpServletResponse.SC_NOT_ACCEPTABLE);
//            } else {
//                response.setStatus(HttpServletResponse.SC_INTERNAL_SERVER_ERROR);
//            }
//
//            //TODO
//            e.printStackTrace();
//            writer.print(e.getMessage());
//        } finally {
//            writer.flush();
//            writer.close();
//        }
//    }
//
//}
