package com.xforceplus.xplat.epcp.sdk.spring.endpoint;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.xforceplus.xplat.epcp.sdk.context.route.CommonResponse;
import com.xforceplus.xplat.epcp.sdk.infrastructure.plugin.extension.XExtension;
import com.xforceplus.xplat.epcp.sdk.infrastructure.plugin.extension.XExtensionDefinition;
import com.xforceplus.xplat.epcp.sdk.infrastructure.plugin.extension.XExtensionModule;
import com.xforceplus.xplat.epcp.sdk.infrastructure.plugin.extension.XExtensionPoint;
import com.xforceplus.xplat.epcp.sdk.spring.dispatcher.ExtentionServiceDispatcher;
import io.github.classgraph.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

/**
 * epcp-sdk
 *
 * @Author 👽 zhaolei
 * @Date 📅 2022/10/11 09:14
 * @Motto: Tools change the world. 🛠
 * @Copyright: xforceplus 🇨🇳
 * @Description:
 */
@RestController
@RequestMapping("/v1/epcp/remote")
public class RemoteController {

    @Autowired
    private final ExtentionServiceDispatcher extentionServiceDispatcher;

    public RemoteController(ExtentionServiceDispatcher extentionServiceDispatcher) {
        this.extentionServiceDispatcher = extentionServiceDispatcher;
    }

    @PostMapping("/invoke/{epImplCode}")
    public CommonResponse invoke(@PathVariable("epImplCode") String epImplCode, @RequestBody String paramListJsonFormat) throws IOException {
        ObjectMapper objectMapper = new ObjectMapper();
        List requestParams = objectMapper.readValue(paramListJsonFormat, List.class);

        CommonResponse commonResponse = new CommonResponse();

        Object result = extentionServiceDispatcher.invokeEpImpl(epImplCode, requestParams.toArray());

        commonResponse.setResult(result);
        commonResponse.setCode(CommonResponse.SUCCESSFUL_CODE);
        return commonResponse;
    }

    private List<Object> convertParams(ObjectMapper objectMapper, List requestParams, Method implMethod) {
        List<Object> params = new ArrayList<>();
        for (int i = 0; i < implMethod.getParameterTypes().length; i++) {
            Class parameterType = implMethod.getParameterTypes()[i];
            Object param = objectMapper.convertValue(requestParams.get(i), parameterType);
            params.add(param);
        }
        return params;
    }

    private Method getImplMethod(ClassInfo epImplClassInfo) {
        Optional<ClassInfo> parentClassOptional = epImplClassInfo.getInterfaces().stream().filter(epImplClassInfoItem -> {
            if (epImplClassInfoItem.hasAnnotation(XExtensionDefinition.class)) {
                return true;
            }

            return false;
        }).findFirst();
        if (!parentClassOptional.isPresent()) {
            throw new RuntimeException("未找到扩展点定义接口类");
        }
        MethodInfoList parentMethodInfo = parentClassOptional.get().getDeclaredMethodInfo();
        if (parentMethodInfo.size() == 0) {
            throw new RuntimeException("未找到扩展点定义方法");
        }
        // 默认取第一个方法
        MethodInfo methodInfo = parentMethodInfo.get(0);
        MethodInfo implMethodInfo = epImplClassInfo.getMethodInfo().getSingleMethod(methodInfo.getName());
        Method implMethod = implMethodInfo.loadClassAndGetMethod();
        return implMethod;
    }

    private ClassInfo getEpImplClassInfo(String epImplCode) {
        ScanResult scan = new ClassGraph().disableJarScanning().enableAllInfo().scan();

        // 扫描扩展点和本机扩展实现
        ClassInfoList xExtensionPointClassList = scan.getClassesImplementing(XExtensionPoint.class);

        String finalEpImplCode = epImplCode;
        Optional<ClassInfo> epImplClassOptional = xExtensionPointClassList.stream().filter(xExtentionPointClassItem -> {
            // 扩展实现
            if (!xExtentionPointClassItem.hasAnnotation(XExtension.class)) {
                return false;
            }
            // 判断 如果是扩展模块则跳过
            if (xExtentionPointClassItem.getClass().equals(XExtensionModule.class)) {
                return false;
            }
            String epImplCodeEach = xExtentionPointClassItem.getAnnotationInfo(XExtension.class).getParameterValues().get("value").getValue() + "";
            if (epImplCodeEach.equals(finalEpImplCode)) {
                return true;
            }
            return false;
        }).findFirst();
        if (!epImplClassOptional.isPresent()) {
            throw new RuntimeException("未匹配到扩展点实现");
        }

        ClassInfo epImplClassInfo = epImplClassOptional.get();
        return epImplClassInfo;
    }
}
