package com.xforceplus.xplat.epcp.sdk.spring.plugin;

import org.pf4j.ExtensionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

import static org.springframework.beans.factory.config.AutowireCapableBeanFactory.AUTOWIRE_BY_NAME;

public class SpringExtensionFactory implements ExtensionFactory {

    private static final Logger log = LoggerFactory.getLogger(SpringExtensionFactory.class);

    private XSpringBootPluginManager springBootPluginManager;

    public SpringExtensionFactory(XSpringBootPluginManager pluginManager) {
        this.springBootPluginManager = pluginManager;
    }

    @Override
    public <T> T create(Class<T> extensionClass) {
        GenericApplicationContext pluginApplicationContext = getApplicationContext(extensionClass);
        Object extension = null;
        try {
            extension = pluginApplicationContext.getBean(extensionClass);
        } catch (NoSuchBeanDefinitionException ignored) {
        } // do nothing
        if (extension == null) {
            RootBeanDefinition beanDefinition = new RootBeanDefinition();
            beanDefinition.setBeanClass(extensionClass);
            beanDefinition.setPrimary(false);
            beanDefinition.setAutowireCandidate(true);
            Object bean = pluginApplicationContext.getBeanFactory().createBean(extensionClass, AUTOWIRE_BY_NAME, true);
            extension = bean;

//            if(XExtensionModule.class.isAssignableFrom(extensionClass)) {
            pluginApplicationContext.getBeanFactory().registerSingleton(extensionClass.getName(), extension);
//            }
        }
        //noinspection unchecked
        return (T) extension;
    }

    public String getExtensionBeanName(Class<?> extensionClass) {
        ApplicationContext pluginAppCtx = getApplicationContext(extensionClass);
        if (pluginAppCtx == null) return null;
        String[] beanNames = pluginAppCtx.getBeanNamesForType(extensionClass);
        return beanNames.length > 0 ? beanNames[0] : null;
    }

    /**
     * TODO
     *
     * @param extensionClass
     * @return
     */
    private Object createWithoutSpring(Class<?> extensionClass) {
        try {
            return extensionClass.newInstance();
        } catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private GenericApplicationContext getApplicationContext(Class<?> extensionClass) {
//        PluginWrapper pluginWrapper = springBootPluginManager.whichPlugin(extensionClass);
//        if (pluginWrapper == null) {
            return springBootPluginManager.getApplicationContext();
//        } else {
//            XplatPlugin plugin = (XplatPlugin) pluginWrapper.getPlugin();
//            return plugin.getApplicationContext();
//        }
    }
}
