package com.xforceplus.xplat.epcp.sdk.spring.plugin;

import com.xforceplus.xplat.epcp.sdk.context.route.RouteConfigContext;
import com.xforceplus.xplat.epcp.sdk.infrastructure.plugin.extension.XExtension;
import com.xforceplus.xplat.epcp.sdk.infrastructure.plugin.extension.XExtensionDefinition;
import com.xforceplus.xplat.epcp.sdk.infrastructure.plugin.extension.XExtensionModule;
import com.xforceplus.xplat.epcp.sdk.infrastructure.plugin.extension.XExtensionPoint;
import com.xforceplus.xplat.epcp.sdk.infrastructure.plugin.extension.dynamic.XPluginManager;
import com.xforceplus.xplat.epcp.sdk.spring.plugin.runtime.ExtensionAutoProxy;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import org.pf4j.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.GenericApplicationContext;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class XSpringBootPluginManager extends XPluginManager
        implements ApplicationContextAware {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    private boolean autoStartPlugin = true;

    private String[] profiles;

    private Map<String, Object> presetProperties;

    private PluginRepository pluginRepository;

    private GenericApplicationContext applicationContext;

    private ExtensionAutoProxy autoProxy;

    private RouteConfigContext routeConfigService;

    public XSpringBootPluginManager(ExtensionAutoProxy autoProxy, RouteConfigContext routeConfigService) {
        super();
        this.autoProxy = autoProxy;
        this.routeConfigService = routeConfigService;
        init();
    }

    public XSpringBootPluginManager(Path pluginsRoot, ExtensionAutoProxy autoProxy, RouteConfigContext routeConfigContext) {
        super(pluginsRoot);
        this.autoProxy = autoProxy;
        this.routeConfigService = routeConfigContext;
        init();
    }

    /**
     * 扫描扩展点接口，初始化实现类
     */
    public void scanAndInitExtensionBean() throws Exception {
        ScanResult scan = new ClassGraph().enableAllInfo().scan();
        //register in applicationContext

        // 扫描扩展点和本机扩展实现
        ClassInfoList classesImplementing = scan.getClassesImplementing(XExtensionPoint.class);

        List<ClassInfo> epDefinitionClassInfoList = new ArrayList<>();
        classesImplementing.forEach(classInfo -> {

            // 扩展实现
            boolean isImpl = classInfo.hasAnnotation(XExtension.class);
            if (isImpl) {
                return;
            }
            // 扩展点定义
            if (classInfo.isInterface()) {
                Class<?> targetClass = classInfo.loadClass();
                if (targetClass == XExtensionModule.class) {
                    // 扩展插件
                    return;
                }
                registerExtension(targetClass);
                if (classInfo.getAnnotationInfo(XExtensionDefinition.class) != null) {
                    epDefinitionClassInfoList.add(classInfo);
                }

            }
        });

        // 找到所有扩展点定义，缓存起来
        List<String> routeQueryEpList = new ArrayList<>();
        epDefinitionClassInfoList.forEach(classInfo -> {
            // 扩展点定义唯一Code
            String epCode = classInfo.getAnnotationInfo(XExtensionDefinition.class).getParameterValues().get("value").getValue() + "";
            routeQueryEpList.add(epCode);
            log.debug("扫描到扩展点 -- " + epCode);
        });
        routeConfigService.setEpList(routeQueryEpList);
    }

    /**
     * 注册扩展点定义类
     * @param tClass
     * @param <T>
     */
    private <T> void registerExtension(Class<T> tClass) {
        T t = autoProxy.initInstance(tClass, applicationContext.getClassLoader(), this);
        applicationContext.getBeanFactory().registerSingleton(tClass.getTypeName(), t);
    }

    public GenericApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public Map<String, Object> getPresetProperties() {
        return this.presetProperties;
    }

    @Override
    protected ExtensionFactory createExtensionFactory() {
        return new SpringExtensionFactory(this);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (GenericApplicationContext) applicationContext;
    }

    @Override
    public PluginDescriptorFinder getPluginDescriptorFinder() {
        return super.getPluginDescriptorFinder();
    }

    @Override
    protected PluginRepository createPluginRepository() {
        this.pluginRepository = super.createPluginRepository();
        return this.pluginRepository;
    }

    public PluginRepository getPluginRepository() {
        return pluginRepository;
    }

    public void setAutoStartPlugin(boolean autoStartPlugin) {
        this.autoStartPlugin = autoStartPlugin;
    }

    public boolean isAutoStartPlugin() {
        return autoStartPlugin;
    }

    public void setProfiles(String[] profiles) {
        this.profiles = profiles;
    }

    public String[] getProfiles() {
        return profiles;
    }

    public void init() {
        loadPlugins();
    }

    @Override
    public void startPlugins() {
        super.startPlugins();
    }

    @Override
    public PluginState startPlugin(String pluginId) {
        return super.startPlugin(pluginId);
    }

    @Override
    public void stopPlugins() {
        super.stopPlugins();
    }

    @Override
    public PluginState stopPlugin(String pluginId) {
        return super.stopPlugin(pluginId);
    }

    public void restartPlugins() {
        stopPlugins();
        startPlugins();
    }

    public PluginState restartPlugin(String pluginId) {
        PluginState pluginState = stopPlugin(pluginId, false);
        if (pluginState != PluginState.STARTED) {
            startPlugin(pluginId);
        }
        return pluginState;
    }

    public void reloadPlugins(boolean restartStartedOnly) {
        stopPlugins();
        List<String> startedPluginIds = new ArrayList<>();
        getPlugins().forEach(plugin -> {
            if (plugin.getPluginState() == PluginState.STARTED) {
                startedPluginIds.add(plugin.getPluginId());
            }
            unloadPlugin(plugin.getPluginId());
        });
        loadPlugins();
        if (restartStartedOnly) {
            startedPluginIds.forEach(pluginId -> {
                // restart started plugin
                if (getPlugin(pluginId) != null) {
                    startPlugin(pluginId);
                }
            });
        } else {
            startPlugins();
        }
    }

    public PluginState reloadPlugins(String pluginId) {
        PluginWrapper plugin = getPlugin(pluginId);
        stopPlugin(pluginId, false);
        unloadPlugin(pluginId, false);
        try {
            loadPlugin(plugin.getPluginPath());
        } catch (Exception ex) {
            return null;
        }

        return startPlugin(pluginId);
    }
}