package com.xforceplus.xplat.epcp.sdk.spring.plugin.runtime;

import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;

public class CustomClassLoaderListableBeanFactory extends DefaultListableBeanFactory {

    private ClassLoader classLoader;

    public CustomClassLoaderListableBeanFactory(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected Class<?> predictBeanType(String beanName, RootBeanDefinition mbd, Class<?>... typesToMatch) {
        try {
            /**
             * try load in current classLoader
             */
            return classLoader.loadClass(beanName);
        } catch (ClassNotFoundException ignored) {
        }
        return super.predictBeanType(beanName, mbd, typesToMatch);
    }
}