package com.xforceplus.xplat.epcp.sdk.spring.plugin.runtime;

import com.xforceplus.xplat.epcp.sdk.infrastructure.plugin.extension.XExtensionPoint;
import com.xforceplus.xplat.epcp.sdk.infrastructure.plugin.extension.dynamic.XPluginManager;
import com.xforceplus.xplat.epcp.sdk.spring.plugin.runtime.exception.XepImplementNotFoundException;
import org.springframework.beans.BeanUtils;
import org.springframework.cglib.core.SpringNamingPolicy;
import org.springframework.cglib.proxy.*;
import org.springframework.util.Assert;
import com.xforceplus.xplat.epcp.sdk.spring.beans.factory.support.CglibSubclassingInstantiationStrategy;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

/**
 * TODO
 */
public class ExtensionAutoProxy {

    public interface ExtensionMethodDispatcher {
        Object dispatch(Class targetClass, List<Object> objects, Method method, Object[] args) throws InvocationTargetException, IllegalAccessException, IOException, Exception;
    }

    private ExtensionMethodDispatcher extensionMethodDispatcher;

    public ExtensionAutoProxy() {
        extensionMethodDispatcher = new PickFirst();
    }

    public ExtensionAutoProxy(ExtensionMethodDispatcher extensionMethodDispatcher) {
        this.extensionMethodDispatcher = extensionMethodDispatcher;
    }

    public <T> T initInstance(Class<T> targetClass, ClassLoader classLoader, XPluginManager pluginManager) {
        Assert.isTrue(XExtensionPoint.class.isAssignableFrom(targetClass), "Only Extension is supported");
        Class<?> enhancedSubclass = createEnhancedSubclass(targetClass, classLoader);
        Object instance = BeanUtils.instantiateClass(enhancedSubclass);
        Factory factory = (Factory) instance;
        factory.setCallbacks(new Callback[]{new LookupOverrideMethodInterceptor(pluginManager, extensionMethodDispatcher, targetClass)});
        return (T) factory;
    }

    /**
     * pick up first
     */
    public static class PickFirst implements ExtensionMethodDispatcher {

        @Override
        public Object dispatch(Class targetClass, List<Object> candidates, Method method, Object[] args) {
            if (!candidates.isEmpty()) {
                return candidates.get(0);
            } else {
                throw new XepImplementNotFoundException("Candidates is empty");
            }
        }
    }

    public Class<?> createEnhancedSubclass(Class target, ClassLoader classLoader) {
        Enhancer enhancer = new Enhancer();
        enhancer.setSuperclass(target);
        enhancer.setNamingPolicy(SpringNamingPolicy.INSTANCE);
        // 这里springboot降到2.0会找不到类，因为变为私有类，所以搬过来重写改为public
        enhancer.setStrategy(new CglibSubclassingInstantiationStrategy.ClassLoaderAwareGeneratorStrategy(classLoader));
        enhancer.setCallbackTypes(new Class[]{LookupOverrideMethodInterceptor.class});
        enhancer.setCallbackFilter(new MethodOverrideCallbackFilter());
        return enhancer.createClass();
    }

    private static class MethodOverrideCallbackFilter implements CallbackFilter {

        public MethodOverrideCallbackFilter() {
        }

        @Override
        public int accept(Method method) {
            return 0;
        }
    }

    private static class LookupOverrideMethodInterceptor implements MethodInterceptor {

        private final XPluginManager manager;

        private final Class targetClass;

        private final ExtensionMethodDispatcher extensionMethodDispatcher;

        public LookupOverrideMethodInterceptor(XPluginManager manager, ExtensionMethodDispatcher extensionMethodDispatcher, Class targetClass) {
            this.manager = manager;
            this.targetClass = targetClass;
            this.extensionMethodDispatcher = extensionMethodDispatcher;
        }

        /**
         *
         * @param obj 这里是扩展点的定义对象
         * @param method
         * @param args
         * @param mp
         * @return
         * @throws Throwable
         */
        @Override
        public Object intercept(Object obj, Method method, Object[] args, MethodProxy mp) throws Throwable {
            //get extension from local manager
            //TODO add instance from remote

            // 扩展点实现的实例
            List extensionInstance = manager.getExtensions(targetClass);

            return extensionMethodDispatcher.dispatch(targetClass, extensionInstance, method, args);
        }
    }
}
