package com.xforceplus.xplat.epcp.sdk.spring.plugin.runtime;

import com.xforceplus.xplat.epcp.sdk.infrastructure.plugin.extension.dynamic.XPluginManager;
import com.xforceplus.xplat.epcp.sdk.spring.plugin.XSpringBootPluginManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

public class ExtensionBeanProcessor implements BeanFactoryPostProcessor {

    private BeanFactory beanFactory;

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        XPluginManager bean = beanFactory.getBean(XPluginManager.class);
        bean = (XPluginManager) beanFactory.initializeBean(bean, bean.getClass().getSimpleName());
        if (bean instanceof XSpringBootPluginManager) {
            try {
                ((XSpringBootPluginManager) bean).scanAndInitExtensionBean();
            } catch (Exception e) {
                throw new BeanInitializationException(e.getMessage());
            }
        }
    }
}
