package com.xforceplus.xplat.epcp.sdk.spring.plugin.runtime;

import com.xforceplus.xplat.epcp.sdk.context.route.RouteConfigContext;
import com.xforceplus.xplat.epcp.sdk.spring.api.UserCenterGatewayApiService;
import com.xforceplus.xplat.epcp.sdk.spring.config.RouteConfiguration;
import lombok.SneakyThrows;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.ApplicationListener;

import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

/**
 * epcp-sdk
 *
 * @Author 👽 zhaolei
 * @Date 📅 2022/9/14 23:18
 * @Motto: Tools change the world. 🛠
 * @Copyright: xforceplus 🇨🇳
 * @Description:
 */
public class RouteConfigInitListener implements ApplicationListener<ApplicationStartedEvent> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Autowired
    RouteConfigContext routeConfigContext;

    @Autowired
    RouteConfiguration routeConfiguration;

    @Autowired
    UserCenterGatewayApiService userCenterGatewayApiService;

    /**
     * 定时执行规则更新
     */
    ScheduledExecutorService scheduledExecutorService = null;

    @SneakyThrows
    @Override
    public void onApplicationEvent(ApplicationStartedEvent event) {

        Map routeInfos = null;
        try {
            routeInfos = userCenterGatewayApiService.routeQuery(routeConfigContext.getEpList());
            routeConfigContext.initRouteConfig(routeInfos);
            routeConfigContext.saveCacheConfigByFile();
        } catch (Exception e) {
            log.error("", e);
            if (!routeConfigContext.initRouteConfigByCacheFile()) {
                throw e;
            }
        }
        initSchedule();
    }

    private void initSchedule() {
        if (scheduledExecutorService != null) {
            return;
        }

        //创建ScheduledExecutorService线程池，做定时器
        scheduledExecutorService = Executors.newScheduledThreadPool(2);

        //开启定时任务
        scheduledExecutorService.scheduleAtFixedRate(new TimerTask() {
            @Override
            public void run() {
                try {
                    Map routeInfos = userCenterGatewayApiService.routeQuery(routeConfigContext.getEpList());
                    routeConfigContext.updateRouteConfig(routeInfos);
                    routeConfigContext.saveCacheConfigByFile();
                } catch (Exception e) {
                    log.error("", e);
                }
            }
        }, 300, 600, TimeUnit.SECONDS);

    }
}