package com.xforceplus.xplat.epcp.sdk.spring.plugin.runtime;

import com.xforceplus.xplat.epcp.sdk.base.anno.OnScene;
import com.xforceplus.xplat.epcp.sdk.base.scene.DynamicSceneProvider;
import com.xforceplus.xplat.epcp.sdk.base.scene.Scene;
import com.xforceplus.xplat.epcp.sdk.context.ContextService;
import com.xforceplus.xplat.epcp.sdk.infrastructure.plugin.extension.XExtension;
import com.xforceplus.xplat.epcp.sdk.spring.plugin.runtime.exception.XepImplementNotFoundException;
import org.springframework.core.annotation.AnnotationUtils;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class SceneAwareMethodDispatcher implements ExtensionAutoProxy.ExtensionMethodDispatcher {

    private final List<DynamicSceneProvider> sceneProviders;

    private final ContextService contextService;

    private final SceneMatcher sceneMatcher;

    public SceneAwareMethodDispatcher(List<DynamicSceneProvider> sceneProviders, ContextService contextService, SceneMatcher sceneMatcher) {
        this.sceneProviders = sceneProviders;
        this.contextService = contextService;
        this.sceneMatcher = sceneMatcher;
    }

    @Override
    public Object dispatch(Class targetClass, List<Object> candidates, Method method, Object[] args) {
        List<Scene> sceneViaContext = sceneProviders.stream()
                .flatMap(x -> x.getSceneViaContext(contextService.getAll()).stream())
                .collect(Collectors.toList());
        List<Object> noSceneCandidates = new ArrayList<>();
        Optional<Object> first = candidates.stream().filter(x -> {
            XExtension xExtension = x.getClass().getAnnotation(XExtension.class);

//            boolean candidateClass = AnnotationUtils.isCandidateClass(x.getClass(), XExtension.class);
            if (xExtension != null) {
                XExtension annotation = AnnotationUtils.getAnnotation(x.getClass(), XExtension.class);
                if (annotation != null) {
                    OnScene[] scenes = annotation.scenes();
                    if (scenes.length == 0) {
                        noSceneCandidates.add(x);
                    }
                    boolean match = sceneMatcher.isMatch(scenes, sceneViaContext);
                    return match;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        }).findFirst();

        if (first.isPresent()) {
            return first.get();
        } else {
            //no scene or all scene failed return to default
            if (noSceneCandidates.isEmpty()) {
                throw new XepImplementNotFoundException("没有找到匹配的扩展实现");
            } else {
                return noSceneCandidates.get(0);
            }
        }
    }
}
