package com.xforceplus.xplat.epcp.sdk.spring.plugin.runtime;

import com.xforceplus.xplat.epcp.sdk.spring.plugin.XSpringBootPluginManager;
import com.xforceplus.xplat.epcp.sdk.spring.plugin.XplatPlugin;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.WebApplicationType;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.util.ReflectionUtils;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class SpringBootstrap extends SpringApplication {

    private final static Logger log = LoggerFactory.getLogger(SpringBootstrap.class);

    public final static String BEAN_PLUGIN = "pf4j.plugin";
    public final static String BEAN_IMPORTED_BEAN_NAMES = "sharedBeanNames";

    private final XplatPlugin plugin;

    private final ApplicationContext mainApplicationContext;

    private final ClassLoader pluginClassLoader;

    private final HashSet<String> importBeanNames = new HashSet<>();

    private final HashSet<Class<?>> importBeanClasses = new HashSet<>();

    private final HashSet<String> importedBeanNames = new HashSet<>();

    private static final String PROPERTY_NAME_AUTOCONFIGURE_EXCLUDE = "spring.autoconfigure.exclude";

    private final Map<String, Object> presetProperties = new HashMap<>();

    public static final String[] DEFAULT_EXCLUDE_CONFIGURATIONS = {
            "com.xforceplus.tech.admin.client.config.AdminClientAutoConfiguration",
            "com.xforceplus.tech.spring.starter.configuration.FrameworkConfiguration",
            "com.xforceplus.tech.replay.configuration.ReplayClientAutoConfiguration",
            "com.xforceplus.tech.replay.configuration.ReplayServerAutoConfiguration",
            "com.xforceplus.tech.replay.configuration.ReporterClientAutoConfiguration",
            "com.xforceplus.tech.replay.configuration.ReporterServerAutoConfiguration",
            "org.springframework.boot.autoconfigure.jackson.JacksonAutoConfiguration",
            // Spring Web MVC
            "org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration",
            "org.springframework.boot.autoconfigure.web.servlet.error.ErrorMvcAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.web.servlet.WebMvcMetricsAutoConfiguration",
            "org.springframework.boot.autoconfigure.web.embedded.EmbeddedWebServerFactoryCustomizerAutoConfiguration",
            "org.springframework.boot.autoconfigure.web.servlet.HttpEncodingAutoConfiguration",
            "org.springframework.boot.autoconfigure.websocket.servlet.WebSocketServletAutoConfiguration",
            // Actuator/JMX
            "org.springframework.boot.actuate.autoconfigure.amqp.RabbitHealthContributorAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.audit.AuditAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.audit.AuditEventsEndpointAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.beans.BeansEndpointAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.cache.CachesEndpointAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.cassandra.CassandraHealthContributorAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.cassandra.CassandraReactiveHealthContributorAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.cloudfoundry.servlet.CloudFoundryActuatorAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.cloudfoundry.reactive.ReactiveCloudFoundryActuatorAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.condition.ConditionsReportEndpointAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.context.properties.ConfigurationPropertiesReportEndpointAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.context.ShutdownEndpointAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.couchbase.CouchbaseHealthContributorAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.couchbase.CouchbaseReactiveHealthContributorAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.elasticsearch.ElasticSearchClientHealthContributorAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.elasticsearch.ElasticSearchJestHealthContributorAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.elasticsearch.ElasticSearchRestHealthContributorAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.endpoint.EndpointAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.endpoint.jmx.JmxEndpointAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.env.EnvironmentEndpointAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.flyway.FlywayEndpointAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.health.HealthContributorAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.health.HealthEndpointAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.health.HealthContributorAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.influx.InfluxDbHealthContributorAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.info.InfoContributorAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.info.InfoEndpointAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.integration.IntegrationGraphEndpointAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.jdbc.DataSourceHealthContributorAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.jms.JmsHealthContributorAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.jolokia.JolokiaEndpointAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.ldap.LdapHealthContributorAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.liquibase.LiquibaseEndpointAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.logging.LogFileWebEndpointAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.logging.LoggersEndpointAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.mail.MailHealthContributorAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.management.HeapDumpWebEndpointAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.management.ThreadDumpEndpointAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.JvmMetricsAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.KafkaMetricsAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.Log4J2MetricsAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.LogbackMetricsAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.MetricsEndpointAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.SystemMetricsAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.amqp.RabbitMetricsAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.cache.CacheMetricsAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.export.appoptics.AppOpticsMetricsExportAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.export.atlas.AtlasMetricsExportAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.export.datadog.DatadogMetricsExportAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.export.dynatrace.DynatraceMetricsExportAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.export.elastic.ElasticMetricsExportAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.export.ganglia.GangliaMetricsExportAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.export.graphite.GraphiteMetricsExportAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.export.humio.HumioMetricsExportAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.export.influx.InfluxMetricsExportAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.export.jmx.JmxMetricsExportAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.export.kairos.KairosMetricsExportAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.export.newrelic.NewRelicMetricsExportAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.export.prometheus.PrometheusMetricsExportAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.export.signalfx.SignalFxMetricsExportAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.export.statsd.StatsdMetricsExportAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.export.wavefront.WavefrontMetricsExportAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.jdbc.DataSourcePoolMetricsAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.jersey.JerseyServerMetricsAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.orm.jpa.HibernateMetricsAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.web.client.HttpClientMetricsAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.web.jetty.JettyMetricsAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.web.reactive.WebFluxMetricsAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.web.servlet.WebMvcMetricsAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.metrics.web.tomcat.TomcatMetricsAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.mongo.MongoHealthContributorAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.mongo.MongoReactiveHealthContributorAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.neo4j.Neo4jHealthContributorAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.redis.RedisHealthContributorAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.redis.RedisReactiveHealthContributorAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.scheduling.ScheduledTasksEndpointAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.security.reactive.ReactiveManagementWebSecurityAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.security.servlet.ManagementWebSecurityAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.session.SessionsEndpointAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.solr.SolrHealthContributorAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.system.DiskSpaceHealthContributorAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.trace.http.HttpTraceAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.trace.http.HttpTraceEndpointAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.web.mappings.MappingsEndpointAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.web.reactive.ReactiveManagementContextAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.web.server.ManagementContextAutoConfiguration",
            "org.springframework.boot.actuate.autoconfigure.web.servlet.ServletManagementContextAutoConfiguration",
            "org.springframework.boot.autoconfigure.admin.SpringApplicationAdminJmxAutoConfiguration",
            "org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration",
            // Spring Security
            "org.springframework.boot.autoconfigure.security.servlet.SecurityAutoConfiguration",
            "org.springframework.boot.autoconfigure.security.servlet.UserDetailsServiceAutoConfiguration",
            "org.springframework.boot.autoconfigure.security.servlet.SecurityFilterAutoConfiguration",
            "org.springframework.boot.autoconfigure.security.reactive.ReactiveSecurityAutoConfiguration",
            "org.springframework.boot.autoconfigure.security.reactive.ReactiveUserDetailsServiceAutoConfiguration",
            "org.springframework.boot.autoconfigure.security.rsocket.RSocketSecurityAutoConfiguration",
            "org.springframework.boot.autoconfigure.security.saml2.Saml2RelyingPartyAutoConfiguration",
            "org.springframework.boot.autoconfigure.sendgrid.SendGridAutoConfiguration",
            "org.springframework.boot.autoconfigure.session.SessionAutoConfiguration",
            "org.springframework.boot.autoconfigure.security.oauth2.client.servlet.OAuth2ClientAutoConfiguration",
            "org.springframework.boot.autoconfigure.security.oauth2.client.reactive.ReactiveOAuth2ClientAutoConfiguration",
            "org.springframework.boot.autoconfigure.security.oauth2.resource.servlet.OAuth2ResourceServerAutoConfiguration",
            "org.springframework.boot.autoconfigure.security.oauth2.resource.reactive.ReactiveOAuth2ResourceServerAutoConfiguration",
            // Spring Cloud
            "org.springframework.cloud.netflix.archaius.ArchaiusAutoConfiguration",
            "org.springframework.cloud.consul.config.ConsulConfigAutoConfiguration",
            "org.springframework.cloud.autoconfigure.ConfigurationPropertiesRebinderAutoConfiguration",
            "org.springframework.cloud.autoconfigure.LifecycleMvcEndpointAutoConfiguration",
            "org.springframework.cloud.autoconfigure.RefreshAutoConfiguration",
            "org.springframework.cloud.autoconfigure.RefreshEndpointAutoConfiguration",
            "org.springframework.cloud.autoconfigure.WritableEnvironmentEndpointAutoConfiguration",
            "org.springframework.cloud.loadbalancer.config.LoadBalancerAutoConfiguration",
            "org.springframework.cloud.loadbalancer.config.BlockingLoadBalancerClientAutoConfiguration",
            "org.springframework.cloud.loadbalancer.config.LoadBalancerCacheAutoConfiguration",
            "org.springframework.cloud.consul.discovery.RibbonConsulAutoConfiguration",
            "org.springframework.cloud.consul.discovery.configclient.ConsulConfigServerAutoConfiguration",
            "org.springframework.cloud.consul.serviceregistry.ConsulAutoServiceRegistrationAutoConfiguration",
            "org.springframework.cloud.consul.serviceregistry.ConsulServiceRegistryAutoConfiguration",
            "org.springframework.cloud.consul.discovery.ConsulDiscoveryClientConfiguration",
            "org.springframework.cloud.consul.discovery.reactive.ConsulReactiveDiscoveryClientConfiguration",
            "org.springframework.cloud.consul.discovery.ConsulCatalogWatchAutoConfiguration",
            "org.springframework.cloud.consul.support.ConsulHeartbeatAutoConfiguration",
    };

    public static final String[] DEFAULT_EXCLUDE_APPLICATION_LISTENERS = {
            "org.springframework.cloud.bootstrap.BootstrapApplicationListener",
            "org.springframework.cloud.bootstrap.LoggingSystemShutdownListener",
            "org.springframework.cloud.context.restart.RestartListener",
    };

    /**
     * Constructor should be the only thing need to take care for this Class.
     * Generally new an instance and {@link #run(String...)} it
     * in {@link SpringBootPlugin#createSpringBootstrap()} method.
     *
     * @param primarySources {@link SpringApplication} that annotated with @SpringBootApplication
     */
    @SuppressWarnings("JavadocReference")
    public SpringBootstrap(XplatPlugin plugin,
                           Class<?>... primarySources) {
        super(new DefaultResourceLoader(plugin.getWrapper().getPluginClassLoader()), primarySources);
        this.plugin = plugin;
        this.mainApplicationContext = plugin.getMainApplicationContext();
        this.pluginClassLoader = plugin.getWrapper().getPluginClassLoader();
        Map<String, Object> presetProperties = ((XSpringBootPluginManager)
                plugin.getWrapper().getPluginManager()).getPresetProperties();
        if (presetProperties != null) {
            this.presetProperties.putAll(presetProperties);
        }
        this.presetProperties.put(PROPERTY_NAME_AUTOCONFIGURE_EXCLUDE,
                getExcludeConfigurations());
    }

    protected String[] getExcludeConfigurations() {
        return DEFAULT_EXCLUDE_CONFIGURATIONS;
    }

    /**
     * Properties that need to be set when this app is started as a plugin.
     * Note that this method only takes effect before {@link #run(String...)} method.
     */
    public SpringBootstrap addPresetProperty(String name, Object value) {
        this.presetProperties.put(name, value);
        return this;
    }

    @Override
    protected void configurePropertySources(ConfigurableEnvironment environment,
                                            String[] args) {
        super.configurePropertySources(environment, args);
        String[] profiles = ((XSpringBootPluginManager)
                plugin.getWrapper().getPluginManager()).getProfiles();
        if (!ArrayUtils.isEmpty(profiles)) {
            environment.setActiveProfiles(profiles);
        }
        environment.getPropertySources().addLast(new ExcludeConfigurations());
    }

    @Override
    protected void bindToSpringApplication(ConfigurableEnvironment environment) {
        super.bindToSpringApplication(environment);
    }

    @Override
    public void setListeners(Collection<? extends ApplicationListener<?>> listeners) {
        super.setListeners(listeners);
    }

    @Override
    public ConfigurableApplicationContext createApplicationContext() {
        setWebApplicationType(WebApplicationType.NONE);
        AnnotationConfigApplicationContext applicationContext =
                (AnnotationConfigApplicationContext) super.createApplicationContext();
        applicationContext.setParent(mainApplicationContext);
        hackBeanFactory(applicationContext);
        applicationContext.setClassLoader(pluginClassLoader);
        applicationContext.getBeanFactory().registerSingleton(BEAN_PLUGIN, plugin);
        applicationContext.getBeanFactory().autowireBean(plugin);
        return applicationContext;
    }

    @Override
    protected void afterRefresh(ConfigurableApplicationContext context, ApplicationArguments args) {
        context.getBeanFactory().registerSingleton(BEAN_IMPORTED_BEAN_NAMES, importedBeanNames);
    }

    private void hackBeanFactory(ApplicationContext applicationContext) {
        BeanFactory beanFactory = new CustomClassLoaderListableBeanFactory(pluginClassLoader);
        Field beanFactoryField = ReflectionUtils.findField(
                applicationContext.getClass(), "beanFactory");
        Field parentBeanFactoryField = ReflectionUtils.findField(
                beanFactory.getClass(), "parentBeanFactory");

        Object originBeanFactory = null;
        if (beanFactoryField != null) {
            beanFactoryField.setAccessible(true);
            originBeanFactory = ReflectionUtils.getField(beanFactoryField, applicationContext);
            ReflectionUtils.setField(beanFactoryField, applicationContext, beanFactory);
        }

        if( parentBeanFactoryField != null && originBeanFactory  != null) {
            parentBeanFactoryField.setAccessible(true);
            Object parent = ReflectionUtils.getField(parentBeanFactoryField, originBeanFactory);
            if(parent != null) {
                ReflectionUtils.setField(parentBeanFactoryField, beanFactory, parent);
            }
        }
    }

    public class ExcludeConfigurations extends MapPropertySource {
        ExcludeConfigurations() {
            super("Exclude Configurations", presetProperties);
        }
    }

}