//package com.xforceplus.tech.spring.plugin.runtime;
//
//import org.pf4j.*;
//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;
//import org.springframework.lang.NonNull;
//
//import java.io.IOException;
//import java.lang.reflect.ReflectPermission;
//import java.net.URL;
//import java.security.*;
//import java.util.Collection;
//import java.util.Collections;
//import java.util.Enumeration;
//import java.util.List;
//import java.util.stream.Collectors;
//
//public class XplatPluginClassloader extends PluginClassLoader {
//
//    private static final Logger log = LoggerFactory.getLogger(XplatPluginClassloader.class);
//
//    private List<String> pluginFirstClasses;
//    private List<String> pluginOnlyResources;
//    private PluginManager pluginManager;
//    private PluginDescriptor pluginDescriptor;
//
//    public XplatPluginClassloader(PluginManager pluginManager, PluginDescriptor pluginDescriptor, ClassLoader parent) {
//        // load class from parent first to avoid same class loaded by different classLoader,
//        // so Spring could autowired bean by type correctly.
//        super(pluginManager, pluginDescriptor, parent, ClassLoadingStrategy.APD);
//        this.pluginManager = pluginManager;
//        this.pluginDescriptor = pluginDescriptor;
//    }
//
//    public void setPluginFirstClasses(@NonNull List<String> pluginFirstClasses) {
//        this.pluginFirstClasses = pluginFirstClasses.stream()
//                .map(pluginFirstClass -> pluginFirstClass
//                        .replaceAll(".", "[$0]")
//                        .replace("[*]", ".*?")
//                        .replace("[?]", ".?"))
//                .collect(Collectors.toList());
//    }
//
//    public void setPluginOnlyResources(@NonNull List<String> pluginOnlyResources) {
//        this.pluginOnlyResources = pluginOnlyResources.stream()
//                .map(pluginFirstClass -> pluginFirstClass
//                        .replaceAll(".", "[$0]")
//                        .replace("[*]", ".*?")
//                        .replace("[?]", ".?"))
//                .collect(Collectors.toList());
//    }
//
//    /**
//     * load class: application ~~ plugin<br>
//     * load ordinary files: plugin ~~ application
//     */
//    @Override
//    public URL getResource(String name) {
//        if (name.endsWith(".class")) return super.getResource(name);
//
//        // load plain resource from local classpath
//        URL url = findResource(name);
//        if (url != null) {
//            log.trace("Found resource '{}' in plugin classpath", name);
//            return url;
//        }
//        log.trace("Couldn't find resource '{}' in plugin classpath. Delegating to parent", name);
//        return super.getResource(name);
//    }
//
//    @Override
//    public Enumeration<URL> getResources(String name) throws IOException {
//        return super.getResources(name);
//    }
//
//    @Override
//    public Class<?> loadClass(String className) throws ClassNotFoundException {
//
//        return super.loadClass(className);
//    }
//
//    protected Class<?> getLoadedClass(String className) {
//        return findLoadedClass(className);
//    }
//
//    protected Class<?> loadClassFromDependencies(String className) {
//        log.trace("Search in dependencies for class '{}'", className);
//        List<PluginDependency> dependencies = pluginDescriptor.getDependencies();
//        for (PluginDependency dependency : dependencies) {
//            ClassLoader classLoader = pluginManager.getPluginClassLoader(dependency.getPluginId());
//
//            // If the dependency is marked as optional, its class loader might not be available.
//            if (classLoader == null && dependency.isOptional()) {
//                continue;
//            }
//
//            try {
//                if (classLoader instanceof XplatPluginClassloader) {
//                    // OPTIMIZATION: load classes from loadedClasses only to speed up class loading
//                    Class<?> clazz = ((XplatPluginClassloader) classLoader).getLoadedClass(className);
//                    if (clazz != null) return clazz;
//                    // continue to find class from dependent plugin recursively
//                    clazz = ((XplatPluginClassloader) classLoader).loadClassFromDependencies(className);
//                    if (clazz != null) return clazz;
//                } else {
//                    return classLoader.loadClass(className);
//                }
//            } catch (ClassNotFoundException e) {
//                // try next dependency
//            }
//        }
//
//        return null;
//    }
//
//    @Override
//    protected URL findResourceFromDependencies(String name) {
//        if (!name.endsWith(".class")) return null; // do not load ordinary resource from dependencies
//        return super.findResourceFromDependencies(name);
//    }
//
//    @Override
//    protected Collection<URL> findResourcesFromDependencies(String name) throws IOException {
//        if (!name.endsWith(".class")) return Collections.emptyList(); // do not load ordinary resource from dependencies
//        return super.findResourcesFromDependencies(name);
//    }
//
//    @Override
//    protected PermissionCollection getPermissions(CodeSource codesource) {
//        Permissions permissions = new Permissions();
//        return permissions;
//    }
//}
