package com.xforceplus.xplat.epcp.sdk.spring.plugin.runtime.impl;

import com.xforceplus.xplat.epcp.sdk.base.anno.OnScene;
import com.xforceplus.xplat.epcp.sdk.base.scene.DynamicSceneProvider;
import com.xforceplus.xplat.epcp.sdk.base.scene.Scene;
import com.xforceplus.xplat.epcp.sdk.spring.plugin.runtime.SceneMatcher;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

/**
 * default Scene Matcher
 */
public class DefaultSceneMatcher implements SceneMatcher , ApplicationContextAware {

    private ApplicationContext applicationContext;

    public DefaultSceneMatcher() {
    }

    @Override
    public boolean isMatch(OnScene[] scenesOnTarget, List<Scene> scenes) {
        Map<String, DynamicSceneProvider> beansOfType = applicationContext.getBeansOfType(DynamicSceneProvider.class);
        return Arrays.stream(scenesOnTarget).anyMatch(scene -> {
           return beansOfType.values().stream().anyMatch(x -> x.matchScore(scene, scenes) > 0);
        });
    }

    @Override
    public boolean isMatch(List<Scene> targetScenes, List<Scene> scenes) {
        Map<String, DynamicSceneProvider> beansOfType = applicationContext.getBeansOfType(DynamicSceneProvider.class);
        return targetScenes.stream().anyMatch(scene -> {
            return beansOfType.values().stream().anyMatch(x -> x.matchScore(scene, scenes) > 0);
        });
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
