package com.xforceplus.xplat.epcp.sdk.spring.plugin.runtime.security;

import org.pf4j.PluginClassLoader;

import java.io.FilePermission;
import java.lang.reflect.ReflectPermission;
import java.security.*;

public class SandboxSecurityPolicy extends Policy {

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        if (isPlugin(domain)) {
            return pluginPermissions();
        }
        else {
            return applicationPermissions();
        }
    }

    private boolean isPlugin(ProtectionDomain domain) {
        return domain.getClassLoader() instanceof PluginClassLoader;
    }

    /**
     * has no permission
     * @return
     */
    private PermissionCollection pluginPermissions() {
//        Permissions permissions = new Permissions(); // No permissions
//        permissions.add(new RuntimePermission("accessClassInPackage.sun.reflect" , "read,write"));
//        return permissions;

        Permissions permissions = new Permissions();
        permissions.add(new AllPermission());
        return permissions;
    }

    private PermissionCollection applicationPermissions() {
        Permissions permissions = new Permissions();
        permissions.add(new AllPermission());
        permissions.add(new ReflectPermission("suppressAccessChecks"));
        permissions.add(new RuntimePermission("accessClassInPackage.sun.reflect", "read,write"));
        return permissions;
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        //order make sure not got over-stack
        if(permission instanceof RuntimePermission) {
            if(isPlugin(domain)) {
                return !permission.getName().startsWith("exitVM");
            } else {
                return true;
            }
        } else {
            return true;
        }
    }
}
