//package com.xforceplus.tech.spring.processor;
//
//import com.fasterxml.jackson.core.JsonProcessingException;
//import com.fasterxml.jackson.core.type.TypeReference;
//import com.fasterxml.jackson.databind.ObjectMapper;
//import com.xforceplus.xplat.epcp.base.pubsub.anno.Topic;
//import com.xforceplus.tech.spring.pubsub.PubSubRuntime;
//import lombok.SneakyThrows;
//import org.springframework.beans.BeansException;
//import org.springframework.beans.factory.config.BeanPostProcessor;
//import org.springframework.beans.factory.config.ConfigurableBeanFactory;
//import org.springframework.beans.factory.config.EmbeddedValueResolver;
//import org.springframework.web.bind.annotation.PostMapping;
//import org.springframework.web.bind.annotation.RequestMapping;
//import org.springframework.web.bind.annotation.RequestMethod;
//
//import java.io.IOException;
//import java.lang.reflect.Method;
//import java.util.ArrayList;
//import java.util.HashMap;
//import java.util.List;
//import java.util.Map;
//
//public class PubSubBeanProcessor implements BeanPostProcessor {
//
//    private static final ObjectMapper MAPPER = new ObjectMapper();
//
//    private final EmbeddedValueResolver embeddedValueResolver;
//
//    public PubSubBeanProcessor(ConfigurableBeanFactory beanFactory) {
//        this.embeddedValueResolver = new EmbeddedValueResolver(beanFactory);
//    }
//
//    @SneakyThrows
//    @Override
//    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
//        if (bean == null) {
//            return null;
//        }
//
//        subscribeToTopics(bean.getClass(), embeddedValueResolver);
//
//        return bean;
//    }
//
//    @Override
//    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
//        return bean;
//    }
//
//    private static void subscribeToTopics(Class clazz, EmbeddedValueResolver embeddedValueResolver) throws IOException {
//        if (clazz == null) {
//            return;
//        }
//
//        subscribeToTopics(clazz.getSuperclass(), embeddedValueResolver);
//        for (Method method : clazz.getDeclaredMethods()) {
//            Topic topic = method.getAnnotation(Topic.class);
//            if (topic == null) {
//                continue;
//            }
//
//            String topicName = embeddedValueResolver.resolveStringValue(topic.name());
//            String pubSubName = embeddedValueResolver.resolveStringValue(topic.pubsubName());
//            if ((topicName != null) && (topicName.length() > 0) && pubSubName != null && pubSubName.length() > 0) {
//                try {
//                    TypeReference<HashMap<String, String>> typeRef
//                            = new TypeReference<HashMap<String, String>>() {};
//                    Map<String, String> metadata = MAPPER.readValue(topic.metadata(), typeRef);
//                    List<String> routes = getAllCompleteRoutesForPost(clazz, method, topicName);
//                    for (String route : routes) {
//                        //add subscription
//                        PubSubRuntime.getInstance().addSubscribedTopic(pubSubName, topicName, route, metadata);
//                    }
//                } catch (JsonProcessingException e) {
//                    throw new IllegalArgumentException("Error while parsing metadata: " + e.toString());
//                }
//            }
//        }
//    }
//
//    private static List<String> getAllCompleteRoutesForPost(Class clazz, Method method, String topicName) {
//        List<String> routesList = new ArrayList<>();
//        RequestMapping clazzRequestMapping =
//                (RequestMapping) clazz.getAnnotation(RequestMapping.class);
//        String[] clazzLevelRoute = null;
//        if (clazzRequestMapping != null) {
//            clazzLevelRoute = clazzRequestMapping.value();
//        }
//        String[] postValueArray = getRoutesForPost(method, topicName);
//        if (postValueArray != null && postValueArray.length >= 1) {
//            for (String postValue : postValueArray) {
//                if (clazzLevelRoute != null && clazzLevelRoute.length >= 1) {
//                    for (String clazzLevelValue : clazzLevelRoute) {
//                        String route = clazzLevelValue + confirmLeadingSlash(postValue);
//                        routesList.add(route);
//                    }
//                } else {
//                    routesList.add(postValue);
//                }
//            }
//        }
//        return routesList;
//    }
//
//    private static String[] getRoutesForPost(Method method, String topicName) {
//        String[] postValueArray = new String[] {topicName};
//        PostMapping postMapping = method.getAnnotation(PostMapping.class);
//        if (postMapping != null) {
//            if (postMapping.path() != null && postMapping.path().length >= 1) {
//                postValueArray = postMapping.path();
//            } else if (postMapping.value() != null && postMapping.value().length >= 1) {
//                postValueArray = postMapping.value();
//            }
//        } else {
//            RequestMapping reqMapping = method.getAnnotation(RequestMapping.class);
//            for (RequestMethod reqMethod : reqMapping.method()) {
//                if (reqMethod == RequestMethod.POST) {
//                    if (reqMapping.path() != null && reqMapping.path().length >= 1) {
//                        postValueArray = reqMapping.path();
//                    } else if (reqMapping.value() != null && reqMapping.value().length >= 1) {
//                        postValueArray = reqMapping.value();
//                    }
//                    break;
//                }
//            }
//        }
//        return postValueArray;
//    }
//
//    private static String confirmLeadingSlash(String path) {
//        if (path != null && path.length() >= 1) {
//            if (!path.substring(0, 1).equals("/")) {
//                return "/" + path;
//            }
//        }
//        return path;
//    }
//}
