//package com.xforceplus.tech.spring.pubsub;
//
//import java.util.*;
//
///**
// */
//public class PubSubRuntime {
//
//    /**
//     * The singleton instance.
//     */
//    private static volatile PubSubRuntime instance;
//
//    /**
//     * List of subscribed topics.
//     */
//    private final Set<String> subscribedTopics = new HashSet<>();
//
//    /**
//     * List of subscriptions.
//     */
//    private final List<TopicSubscription> subscriptions = new ArrayList<>();
//
//    /**
//     * Private constructor to make this singleton.
//     */
//    private PubSubRuntime() {
//    }
//
//    public static PubSubRuntime getInstance() {
//        if (instance == null) {
//            synchronized (PubSubRuntime.class) {
//                if (instance == null) {
//                    instance = new PubSubRuntime();
//                }
//            }
//        }
//
//        return instance;
//    }
//
//    public synchronized void addSubscribedTopic(String pubsubName,
//                                                String topicName,
//                                                String route,
//                                                Map<String,String> metadata) {
//        if (!this.subscribedTopics.contains(topicName)) {
//            this.subscribedTopics.add(topicName);
//            this.subscriptions.add(new TopicSubscription(pubsubName, topicName, route, metadata));
//        }
//    }
//
//    public synchronized TopicSubscription[] listSubscribedTopics() {
//        return this.subscriptions.toArray(new TopicSubscription[0]);
//    }
//}