package com.xfrcpls.xcomponent.xrmq.domain.configuration;

import com.xfrcpls.xcomponent.xrmq.domain.adapter.MessageBodyAdapter;
import com.xfrcpls.xcomponent.xrmq.domain.model.RmqMessageConverter;
import com.xfrcpls.xcomponent.xrmq.domain.model.properties.XrmqProperties;
import com.xfrcpls.xcomponent.xrmq.domain.translator.RmqMessageTranslator;
import org.apache.rocketmq.spring.support.RocketMQMessageConverter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.retry.annotation.EnableRetry;

@Configuration
@ConditionalOnMissingBean(RocketMQMessageConverter.class)
@ConditionalOnProperty(prefix = "xrmq", name = "enabled", havingValue = "true")
@Order(Ordered.HIGHEST_PRECEDENCE + 100)
@EnableRetry
public class MessageConverterConfiguration {

    @Bean
    public RocketMQMessageConverter createRocketMqMessageConverter(
        final MessageBodyAdapter messageBodyAdapter,
        final RmqMessageTranslator rmqMessageTranslator,
        final XrmqProperties xrmqProperties
    ) {
        return new RmqMessageConverter(messageBodyAdapter, rmqMessageTranslator, xrmqProperties);
    }
}
