package com.xfrcpls.xcomponent.xrmq.domain.exception;

import com.xfrcpls.xcomponent.xrmq.domain.model.DelayLevel;
import org.apache.rocketmq.spring.exception.RocketMQDelayException;

public class RmqDelayException extends RocketMQDelayException {
    protected RmqDelayException(String message, Throwable throwable, int delayTimeLevel) {
        super(message, throwable, delayTimeLevel);
    }

    public static RmqDelayException create(String message) {
        return create(message, null, DelayLevel.IMMEDIATELY_OR_BROKE_CONTROL);
    }

    public static RmqDelayException create(String message, int delayLevel) {
        return create(message, null, delayLevel);
    }

    public static RmqDelayException create(String message, Throwable cause) {
        return new RmqDelayException(message, cause, DelayLevel.IMMEDIATELY_OR_BROKE_CONTROL);
    }

    public static RmqDelayException create(String message, Throwable cause, int delayLevel) {
        return new RmqDelayException(message, cause, delayLevel);
    }
}
