package com.xfrcpls.xcomponent.xrmq.domain.model;

import lombok.*;
import org.apache.commons.lang3.StringUtils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class RmqMessage<T> {

    /**
     * 主题
     */
    private String topic;

    /**
     * 标签
     */
    private String tags;

    /**
     * 关键字
     */
    private String keys;

    /**
     * 延时等级
     */
    private int delayTimeLevel;

    /**
     * 消息属性
     */
    @Setter(AccessLevel.PRIVATE)
    private Map<String, String> properties = new HashMap<>();

    /**
     * 消息体
     */
    private T body;

    public void putProperty(final String key, final String value) {
        this.properties.put(key, value);
    }

    public String getProperty(final String key) {
        return this.properties.get(key);
    }

    public boolean containsProperty(final String key) {
        return this.properties.containsKey(key);
    }

    public void setKeys(final String keys) {
        this.keys = keys;
    }

    public void setKeys(final Collection<String> keys) {
        if (keys == null) {
            return;
        }

        this.keys = StringUtils.join(keys, " ").trim();
    }
}
