package com.xfrcpls.xcomponent.xrmq.domain.model;

import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.messaging.support.MessageBuilder;

public class RmqProducer {
    private final RocketMQTemplate template;
    private final StandardEnvironment environment;

    public RmqProducer(final RocketMQTemplate template, final StandardEnvironment environment) {
        this.template = template;
        this.environment = environment;
    }

    public <T> SendResult syncSend(String topic, RmqMessage<T> rmqMessage) {
        final String actualTopic = this.environment.resolvePlaceholders(topic);
        rmqMessage.setTopic(actualTopic);
        return template.syncSend(actualTopic, MessageBuilder.withPayload(rmqMessage).build());
    }
}
