package com.xfrcpls.xcomponent.xrmq.domain.translator;

import com.alibaba.fastjson.JSON;
import com.xfrcpls.xcomponent.xrmq.domain.model.BaseRmqMessage;
import com.xfrcpls.xcomponent.xrmq.domain.model.RmqMessage;
import com.xfrcpls.xcomponent.xrmq.domain.model.RmqMessageExt;
import org.apache.rocketmq.common.message.MessageExt;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;

import java.util.Map;

import static org.apache.rocketmq.common.message.MessageConst.*;
import static org.mapstruct.MappingConstants.ComponentModel.SPRING;

@Mapper(componentModel = SPRING)
public interface RmqMessageTranslator {

    @Mapping(target = "delayTimeLevel", source = "messageExt.delayTimeLevel")
    @Mapping(target = "body", source = "body")
    @Mapping(target = "properties", source = "properties")
    @Mapping(target = "keys", source = "messageExt.keys")
    @Mapping(target = "topic", source = "messageExt.topic")
    @Mapping(target = "tags", source = "messageExt.tags")
    @Mapping(target = "reconsumeTimes", source = "messageExt.reconsumeTimes")
    @Mapping(target = "msgId", source = "messageExt.msgId")
    RmqMessageExt from(Object body, Map<String, String> properties, MessageExt messageExt);

    @Mapping(target = "body", expression = "java( rmqMessage.getBody() instanceof String ? (String)rmqMessage.getBody() : com.alibaba.fastjson.JSON.toJSONString(rmqMessage.getBody()) )")
    BaseRmqMessage toBaseRmqMessage(RmqMessage rmqMessage);

    default Message<?> toSpringMessage(BaseRmqMessage baseRmqMessage, String keys, String tags, int delayLevel) {
        final MessageBuilder<String> messageBuilder = MessageBuilder.withPayload(JSON.toJSONString(baseRmqMessage));

        if (keys != null) {
            messageBuilder.setHeader(PROPERTY_KEYS, keys);
        }

        if (tags != null) {
            messageBuilder.setHeader(PROPERTY_TAGS, tags);
        }

        if (delayLevel >= 0) {
            messageBuilder.setHeader(PROPERTY_DELAY_TIME_LEVEL, delayLevel);
        }

        return messageBuilder.build();
    }
}
