package com.xfrcpls.xcomponent.xrmq.domain.util;

import org.apache.commons.codec.binary.Hex;

import java.security.MessageDigest;
import java.util.UUID;

/**
 * ID工具
 *
 * @author gulei
 * @date 2023/01/19
 */
public class IdUtil {
    private IdUtil() {
        throw new IllegalStateException("Utility class");
    }

    /**
     * 生成32位，不带'-'的UUID
     *
     * @return UUID 例如: 9b951384f80c4ee58025195c585c6149
     */
    public static String genUuid32() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    /**
     * 生成36位，带有'-'的UUID
     *
     * @return UUID 例如: a7c3bbb8-9420-4960-b86d-88556f783e96
     */
    public static String genUuid36() {
        return UUID.randomUUID().toString();
    }

    /**
     * 按字典和指定长度生成随机ID。
     * <p>
     * 参数不合法时，返回null
     *
     * @param dictionary 字典，必须为非空字符串
     * @param length     长度，必须是大于0的数字
     * @return ID
     */
    public static String genRandomId(String dictionary, int length) {
        if (dictionary == null || dictionary.length() == 0 || length <= 0) {
            return null;
        }

        final StringBuilder result = new StringBuilder(length);

        for (int i = 0; i < length; i++) {
            final int index = (int) (Math.random() * dictionary.length());
            result.append(dictionary.charAt(index));
        }

        return result.toString();
    }

    public static String getMD5(byte[] data) {
        try {
            // 创建MessageDigest实例，指定MD5算法
            final MessageDigest md = MessageDigest.getInstance("MD5");

            // 对字节数组进行哈希计算
            md.update(data);

            // 返回16进制字符串
            return Hex.encodeHexString(md.digest());
        } catch (Exception e) {
            return null;
        }
    }
}
