/*
 * Decompiled with CFR 0.152.
 */
package org.yiwan.seiya.tower.callback.algorithm;

import com.google.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.shardingsphere.api.sharding.complex.ComplexKeysShardingAlgorithm;
import org.apache.shardingsphere.api.sharding.complex.ComplexKeysShardingValue;

public class ShardingTableAlgorithm
implements ComplexKeysShardingAlgorithm {
    private static final String COLUMN_SERIAL_NO = "serial_no";
    private static final String COLUMN_CREATE_TIME = "create_time";
    private static final String TABLE_PREFIX = "t_cb_send_record_%s";
    private static final String yyyyMM = "yyyyMM";

    public Collection<String> doSharding(Collection availableTargetNames, ComplexKeysShardingValue shardingValue) {
        HashSet tableNames = Sets.newHashSet();
        Map map = shardingValue.getColumnNameAndShardingValuesMap();
        if (map != null) {
            Collection serialNos;
            Collection createTimes = (Collection)map.get(COLUMN_CREATE_TIME);
            if (createTimes != null && !createTimes.isEmpty()) {
                createTimes.forEach(time -> {
                    if (time instanceof String) {
                        String timestr = ShardingTableAlgorithm.getYearMonth(time.toString());
                        String tableName = String.format(TABLE_PREFIX, timestr);
                        if (availableTargetNames.contains(tableName)) {
                            tableNames.add(tableName);
                        }
                    } else if (time instanceof Date) {
                        Date date = (Date)time;
                        String timestr = ShardingTableAlgorithm.getYearMonth(date);
                        String tableName = String.format(TABLE_PREFIX, timestr);
                        if (availableTargetNames.contains(tableName)) {
                            tableNames.add(tableName);
                        }
                    }
                });
            }
            if ((serialNos = (Collection)map.get(COLUMN_SERIAL_NO)) != null && !serialNos.isEmpty()) {
                serialNos.forEach(no -> {
                    String tableName;
                    String nostr;
                    if (no != null && (nostr = no.toString()).length() > 6 && availableTargetNames.contains(tableName = String.format(TABLE_PREFIX, nostr.substring(0, 6)))) {
                        tableNames.add(tableName);
                    }
                });
            }
        }
        return tableNames;
    }

    public static String getYearMonth(@NotNull String time) {
        if (StringUtils.isNotBlank((CharSequence)time)) {
            time = time.replaceAll("\\s|-|/", "");
            return time.substring(0, 6);
        }
        return null;
    }

    public static String getYearMonth(@NotNull Date time) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        simpleDateFormat.applyPattern(yyyyMM);
        return simpleDateFormat.format(time);
    }
}

