/*
 * Decompiled with CFR 0.152.
 */
package org.yiwan.seiya.tower.goods.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;

@Validated
public class TaxNumber {
    @JsonProperty(value="conversionCode")
    private String conversionCode = null;
    @JsonProperty(value="defaultTaxCode")
    private DefaultTaxCodeEnum defaultTaxCode = null;
    @JsonProperty(value="taxCode")
    private String taxCode = null;
    @JsonProperty(value="taxName")
    private String taxName = null;
    @JsonProperty(value="taxPre")
    private TaxPreEnum taxPre = null;
    @JsonProperty(value="taxPreCon")
    private String taxPreCon = null;
    @JsonProperty(value="taxRate")
    private BigDecimal taxRate = null;
    @JsonProperty(value="taxShorName")
    private String taxShorName = null;
    @JsonProperty(value="zeroTax")
    private ZeroTaxEnum zeroTax = null;

    public TaxNumber withConversionCode(String conversionCode) {
        this.conversionCode = conversionCode;
        return this;
    }

    @ApiModelProperty(required=true, value="\u7a0e\u7f16\u8f6c\u6362\u4ee3\u7801")
    @NotNull
    public String getConversionCode() {
        return this.conversionCode;
    }

    public void setConversionCode(String conversionCode) {
        this.conversionCode = conversionCode;
    }

    public TaxNumber withDefaultTaxCode(DefaultTaxCodeEnum defaultTaxCode) {
        this.defaultTaxCode = defaultTaxCode;
        return this;
    }

    @ApiModelProperty(required=true, value="\u662f\u5426\u9ed8\u8ba4\u7a0e\u7f16")
    @NotNull
    public DefaultTaxCodeEnum getDefaultTaxCode() {
        return this.defaultTaxCode;
    }

    public void setDefaultTaxCode(DefaultTaxCodeEnum defaultTaxCode) {
        this.defaultTaxCode = defaultTaxCode;
    }

    public TaxNumber withTaxCode(String taxCode) {
        this.taxCode = taxCode;
        return this;
    }

    @ApiModelProperty(required=true, value="\u7a0e\u6536\u5206\u7c7b\u7f16\u7801")
    @NotNull
    public String getTaxCode() {
        return this.taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public TaxNumber withTaxName(String taxName) {
        this.taxName = taxName;
        return this;
    }

    @ApiModelProperty(required=true, value="\u7a0e\u7f16\u540d\u79f0")
    @NotNull
    public String getTaxName() {
        return this.taxName;
    }

    public void setTaxName(String taxName) {
        this.taxName = taxName;
    }

    public TaxNumber withTaxPre(TaxPreEnum taxPre) {
        this.taxPre = taxPre;
        return this;
    }

    @ApiModelProperty(required=true, value="\u662f\u5426\u4eab\u53d7\u4f18\u60e0\u653f\u7b56")
    @NotNull
    public TaxPreEnum getTaxPre() {
        return this.taxPre;
    }

    public void setTaxPre(TaxPreEnum taxPre) {
        this.taxPre = taxPre;
    }

    public TaxNumber withTaxPreCon(String taxPreCon) {
        this.taxPreCon = taxPreCon;
        return this;
    }

    @ApiModelProperty(value="\u4f18\u60e0\u653f\u7b56\u5185\u5bb9")
    public String getTaxPreCon() {
        return this.taxPreCon;
    }

    public void setTaxPreCon(String taxPreCon) {
        this.taxPreCon = taxPreCon;
    }

    public TaxNumber withTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
        return this;
    }

    @ApiModelProperty(required=true, value="\u7a0e\u7387")
    @NotNull
    @Valid
    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public TaxNumber withTaxShorName(String taxShorName) {
        this.taxShorName = taxShorName;
        return this;
    }

    @ApiModelProperty(required=true, value="\u7a0e\u7f16\u7b80\u79f0")
    @NotNull
    public String getTaxShorName() {
        return this.taxShorName;
    }

    public void setTaxShorName(String taxShorName) {
        this.taxShorName = taxShorName;
    }

    public TaxNumber withZeroTax(ZeroTaxEnum zeroTax) {
        this.zeroTax = zeroTax;
        return this;
    }

    @ApiModelProperty(value="\u96f6\u7a0e\u7387\u6807\u8bc6")
    public ZeroTaxEnum getZeroTax() {
        return this.zeroTax;
    }

    public void setZeroTax(ZeroTaxEnum zeroTax) {
        this.zeroTax = zeroTax;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaxNumber taxNumber = (TaxNumber)o;
        return Objects.equals(this.conversionCode, taxNumber.conversionCode) && Objects.equals((Object)this.defaultTaxCode, (Object)taxNumber.defaultTaxCode) && Objects.equals(this.taxCode, taxNumber.taxCode) && Objects.equals(this.taxName, taxNumber.taxName) && Objects.equals((Object)this.taxPre, (Object)taxNumber.taxPre) && Objects.equals(this.taxPreCon, taxNumber.taxPreCon) && Objects.equals(this.taxRate, taxNumber.taxRate) && Objects.equals(this.taxShorName, taxNumber.taxShorName) && Objects.equals((Object)this.zeroTax, (Object)taxNumber.zeroTax);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.conversionCode, this.defaultTaxCode, this.taxCode, this.taxName, this.taxPre, this.taxPreCon, this.taxRate, this.taxShorName, this.zeroTax});
    }

    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "{}";
        }
    }

    public static TaxNumber fromString(String json) throws IOException {
        return (TaxNumber)new ObjectMapper().readValue(json, TaxNumber.class);
    }

    public static enum ZeroTaxEnum {
        _0("0"),
        _1("1"),
        _2("2"),
        _3("3");

        private String value;

        private ZeroTaxEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ZeroTaxEnum fromValue(String text) {
            for (ZeroTaxEnum b : ZeroTaxEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum TaxPreEnum {
        _0("0"),
        _1("1");

        private String value;

        private TaxPreEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TaxPreEnum fromValue(String text) {
            for (TaxPreEnum b : TaxPreEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum DefaultTaxCodeEnum {
        _0("0"),
        _1("1");

        private String value;

        private DefaultTaxCodeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static DefaultTaxCodeEnum fromValue(String text) {
            for (DefaultTaxCodeEnum b : DefaultTaxCodeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

