package org.yiwan.seiya.tower.goods.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.yiwan.seiya.tower.goods.model.Goods;
import org.yiwan.seiya.tower.goods.model.TaxNumber;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * CreateGoodsParam
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-10-24T01:49:11.929+08:00")
public class CreateGoodsParam   {
    @JsonProperty("goods")
    private Goods goods = null;

    @JsonProperty("taxNumbers")
    @Valid
    private List<TaxNumber> taxNumbers = null;

    public CreateGoodsParam withGoods(Goods goods) {
        this.goods = goods;
        return this;
    }

    /**
    * 商品信息
    * @return goods
    **/
    @ApiModelProperty(required = true, value = "商品信息")
  @NotNull

  @Valid

    public Goods getGoods() {
        return goods;
    }

    public void setGoods(Goods goods) {
        this.goods = goods;
    }

    public CreateGoodsParam withTaxNumbers(List<TaxNumber> taxNumbers) {
        this.taxNumbers = taxNumbers;
        return this;
    }

    public CreateGoodsParam withTaxNumbersAdd(TaxNumber taxNumbers) {
        if (this.taxNumbers == null) {
            this.taxNumbers = new ArrayList<TaxNumber>();
        }
        this.taxNumbers.add(taxNumbers);
        return this;
    }

    /**
    * 税转信息
    * @return taxNumbers
    **/
    @ApiModelProperty(value = "税转信息")

  @Valid

    public List<TaxNumber> getTaxNumbers() {
        return taxNumbers;
    }

    public void setTaxNumbers(List<TaxNumber> taxNumbers) {
        this.taxNumbers = taxNumbers;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateGoodsParam createGoodsParam = (CreateGoodsParam) o;
        return Objects.equals(this.goods, createGoodsParam.goods) &&
            Objects.equals(this.taxNumbers, createGoodsParam.taxNumbers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(goods, taxNumbers);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link CreateGoodsParam }.
     */
    public static CreateGoodsParam fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, CreateGoodsParam.class);
    }
}

