package org.yiwan.seiya.tower.goods.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.yiwan.seiya.tower.goods.model.GoodsRecord;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * GoodsPage
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-10-24T01:49:11.929+08:00")
public class GoodsPage   {
    @JsonProperty("goodsRecords")
    @Valid
    private List<GoodsRecord> goodsRecords = null;

    @JsonProperty("total")
    private Long total = null;

    public GoodsPage withGoodsRecords(List<GoodsRecord> goodsRecords) {
        this.goodsRecords = goodsRecords;
        return this;
    }

    public GoodsPage withGoodsRecordsAdd(GoodsRecord goodsRecords) {
        if (this.goodsRecords == null) {
            this.goodsRecords = new ArrayList<GoodsRecord>();
        }
        this.goodsRecords.add(goodsRecords);
        return this;
    }

    /**
    * 商品记录
    * @return goodsRecords
    **/
    @ApiModelProperty(value = "商品记录")

  @Valid

    public List<GoodsRecord> getGoodsRecords() {
        return goodsRecords;
    }

    public void setGoodsRecords(List<GoodsRecord> goodsRecords) {
        this.goodsRecords = goodsRecords;
    }

    public GoodsPage withTotal(Long total) {
        this.total = total;
        return this;
    }

    /**
    * 总条数
    * @return total
    **/
    @ApiModelProperty(value = "总条数")


    public Long getTotal() {
        return total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GoodsPage goodsPage = (GoodsPage) o;
        return Objects.equals(this.goodsRecords, goodsPage.goodsRecords) &&
            Objects.equals(this.total, goodsPage.total);
    }

    @Override
    public int hashCode() {
        return Objects.hash(goodsRecords, total);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link GoodsPage }.
     */
    public static GoodsPage fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, GoodsPage.class);
    }
}

