package org.yiwan.seiya.tower.goods.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * GoodsTypeInfo
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-10-24T01:49:11.929+08:00")
public class GoodsTypeInfo   {
    @JsonProperty("appId")
    private Long appId = null;

    @JsonProperty("appName")
    private String appName = null;

  /**
   * 商品类型
   */
  public enum CategoryEnum {
    _0("0"),
    
    _1("1");

    private String value;

    CategoryEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static CategoryEnum fromValue(String text) {
      for (CategoryEnum b : CategoryEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

    @JsonProperty("category")
    private CategoryEnum category = null;

    @JsonProperty("tenantId")
    private Long tenantId = null;

    @JsonProperty("tenantName")
    private String tenantName = null;

    @JsonProperty("typeCode")
    private String typeCode = null;

    @JsonProperty("typeName")
    private String typeName = null;

    public GoodsTypeInfo withAppId(Long appId) {
        this.appId = appId;
        return this;
    }

    /**
    * 产品线id
    * @return appId
    **/
    @ApiModelProperty(required = true, value = "产品线id")
  @NotNull


    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public GoodsTypeInfo withAppName(String appName) {
        this.appName = appName;
        return this;
    }

    /**
    * 产品线名称
    * @return appName
    **/
    @ApiModelProperty(required = true, value = "产品线名称")
  @NotNull


    public String getAppName() {
        return appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public GoodsTypeInfo withCategory(CategoryEnum category) {
        this.category = category;
        return this;
    }

    /**
    * 商品类型
    * @return category
    **/
    @ApiModelProperty(required = true, value = "商品类型")
  @NotNull


    public CategoryEnum getCategory() {
        return category;
    }

    public void setCategory(CategoryEnum category) {
        this.category = category;
    }

    public GoodsTypeInfo withTenantId(Long tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
    * 租户id
    * @return tenantId
    **/
    @ApiModelProperty(value = "租户id")


    public Long getTenantId() {
        return tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public GoodsTypeInfo withTenantName(String tenantName) {
        this.tenantName = tenantName;
        return this;
    }

    /**
    * 租户名称
    * @return tenantName
    **/
    @ApiModelProperty(value = "租户名称")


    public String getTenantName() {
        return tenantName;
    }

    public void setTenantName(String tenantName) {
        this.tenantName = tenantName;
    }

    public GoodsTypeInfo withTypeCode(String typeCode) {
        this.typeCode = typeCode;
        return this;
    }

    /**
    * 类型代码
    * @return typeCode
    **/
    @ApiModelProperty(value = "类型代码")


    public String getTypeCode() {
        return typeCode;
    }

    public void setTypeCode(String typeCode) {
        this.typeCode = typeCode;
    }

    public GoodsTypeInfo withTypeName(String typeName) {
        this.typeName = typeName;
        return this;
    }

    /**
    * 类型名称
    * @return typeName
    **/
    @ApiModelProperty(value = "类型名称")


    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GoodsTypeInfo goodsTypeInfo = (GoodsTypeInfo) o;
        return Objects.equals(this.appId, goodsTypeInfo.appId) &&
            Objects.equals(this.appName, goodsTypeInfo.appName) &&
            Objects.equals(this.category, goodsTypeInfo.category) &&
            Objects.equals(this.tenantId, goodsTypeInfo.tenantId) &&
            Objects.equals(this.tenantName, goodsTypeInfo.tenantName) &&
            Objects.equals(this.typeCode, goodsTypeInfo.typeCode) &&
            Objects.equals(this.typeName, goodsTypeInfo.typeName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appId, appName, category, tenantId, tenantName, typeCode, typeName);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link GoodsTypeInfo }.
     */
    public static GoodsTypeInfo fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, GoodsTypeInfo.class);
    }
}

