package org.yiwan.seiya.tower.goods.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * RelationParams
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-10-24T01:49:11.929+08:00")
public class RelationParams   {
    @JsonProperty("goodsId")
    private Long goodsId = null;

    @JsonProperty("mappingGoodsIds")
    @Valid
    private List<Long> mappingGoodsIds = null;

    public RelationParams withGoodsId(Long goodsId) {
        this.goodsId = goodsId;
        return this;
    }

    /**
    * 商品id
    * @return goodsId
    **/
    @ApiModelProperty(value = "商品id")


    public Long getGoodsId() {
        return goodsId;
    }

    public void setGoodsId(Long goodsId) {
        this.goodsId = goodsId;
    }

    public RelationParams withMappingGoodsIds(List<Long> mappingGoodsIds) {
        this.mappingGoodsIds = mappingGoodsIds;
        return this;
    }

    public RelationParams withMappingGoodsIdsAdd(Long mappingGoodsIds) {
        if (this.mappingGoodsIds == null) {
            this.mappingGoodsIds = new ArrayList<Long>();
        }
        this.mappingGoodsIds.add(mappingGoodsIds);
        return this;
    }

    /**
    * 映射商品id
    * @return mappingGoodsIds
    **/
    @ApiModelProperty(value = "映射商品id")


    public List<Long> getMappingGoodsIds() {
        return mappingGoodsIds;
    }

    public void setMappingGoodsIds(List<Long> mappingGoodsIds) {
        this.mappingGoodsIds = mappingGoodsIds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RelationParams relationParams = (RelationParams) o;
        return Objects.equals(this.goodsId, relationParams.goodsId) &&
            Objects.equals(this.mappingGoodsIds, relationParams.mappingGoodsIds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(goodsId, mappingGoodsIds);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link RelationParams }.
     */
    public static RelationParams fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, RelationParams.class);
    }
}

