package org.yiwan.seiya.tower.goods.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * TaxNumber
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-10-24T01:49:11.929+08:00")
public class TaxNumber   {
    @JsonProperty("conversionCode")
    private String conversionCode = null;

  /**
   * 是否默认税编
   */
  public enum DefaultTaxCodeEnum {
    _0("0"),
    
    _1("1");

    private String value;

    DefaultTaxCodeEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DefaultTaxCodeEnum fromValue(String text) {
      for (DefaultTaxCodeEnum b : DefaultTaxCodeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

    @JsonProperty("defaultTaxCode")
    private DefaultTaxCodeEnum defaultTaxCode = null;

    @JsonProperty("taxCode")
    private String taxCode = null;

    @JsonProperty("taxName")
    private String taxName = null;

  /**
   * 是否享受优惠政策
   */
  public enum TaxPreEnum {
    _0("0"),
    
    _1("1");

    private String value;

    TaxPreEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TaxPreEnum fromValue(String text) {
      for (TaxPreEnum b : TaxPreEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

    @JsonProperty("taxPre")
    private TaxPreEnum taxPre = null;

    @JsonProperty("taxPreCon")
    private String taxPreCon = null;

    @JsonProperty("taxRate")
    private BigDecimal taxRate = null;

    @JsonProperty("taxShorName")
    private String taxShorName = null;

  /**
   * 零税率标识
   */
  public enum ZeroTaxEnum {
    _0("0"),
    
    _1("1"),
    
    _2("2"),
    
    _3("3");

    private String value;

    ZeroTaxEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ZeroTaxEnum fromValue(String text) {
      for (ZeroTaxEnum b : ZeroTaxEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

    @JsonProperty("zeroTax")
    private ZeroTaxEnum zeroTax = null;

    public TaxNumber withConversionCode(String conversionCode) {
        this.conversionCode = conversionCode;
        return this;
    }

    /**
    * 税编转换代码
    * @return conversionCode
    **/
    @ApiModelProperty(required = true, value = "税编转换代码")
  @NotNull


    public String getConversionCode() {
        return conversionCode;
    }

    public void setConversionCode(String conversionCode) {
        this.conversionCode = conversionCode;
    }

    public TaxNumber withDefaultTaxCode(DefaultTaxCodeEnum defaultTaxCode) {
        this.defaultTaxCode = defaultTaxCode;
        return this;
    }

    /**
    * 是否默认税编
    * @return defaultTaxCode
    **/
    @ApiModelProperty(required = true, value = "是否默认税编")
  @NotNull


    public DefaultTaxCodeEnum getDefaultTaxCode() {
        return defaultTaxCode;
    }

    public void setDefaultTaxCode(DefaultTaxCodeEnum defaultTaxCode) {
        this.defaultTaxCode = defaultTaxCode;
    }

    public TaxNumber withTaxCode(String taxCode) {
        this.taxCode = taxCode;
        return this;
    }

    /**
    * 税收分类编码
    * @return taxCode
    **/
    @ApiModelProperty(required = true, value = "税收分类编码")
  @NotNull


    public String getTaxCode() {
        return taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public TaxNumber withTaxName(String taxName) {
        this.taxName = taxName;
        return this;
    }

    /**
    * 税编名称
    * @return taxName
    **/
    @ApiModelProperty(required = true, value = "税编名称")
  @NotNull


    public String getTaxName() {
        return taxName;
    }

    public void setTaxName(String taxName) {
        this.taxName = taxName;
    }

    public TaxNumber withTaxPre(TaxPreEnum taxPre) {
        this.taxPre = taxPre;
        return this;
    }

    /**
    * 是否享受优惠政策
    * @return taxPre
    **/
    @ApiModelProperty(required = true, value = "是否享受优惠政策")
  @NotNull


    public TaxPreEnum getTaxPre() {
        return taxPre;
    }

    public void setTaxPre(TaxPreEnum taxPre) {
        this.taxPre = taxPre;
    }

    public TaxNumber withTaxPreCon(String taxPreCon) {
        this.taxPreCon = taxPreCon;
        return this;
    }

    /**
    * 优惠政策内容
    * @return taxPreCon
    **/
    @ApiModelProperty(value = "优惠政策内容")


    public String getTaxPreCon() {
        return taxPreCon;
    }

    public void setTaxPreCon(String taxPreCon) {
        this.taxPreCon = taxPreCon;
    }

    public TaxNumber withTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
        return this;
    }

    /**
    * 税率
    * @return taxRate
    **/
    @ApiModelProperty(required = true, value = "税率")
  @NotNull

  @Valid

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public TaxNumber withTaxShorName(String taxShorName) {
        this.taxShorName = taxShorName;
        return this;
    }

    /**
    * 税编简称
    * @return taxShorName
    **/
    @ApiModelProperty(required = true, value = "税编简称")
  @NotNull


    public String getTaxShorName() {
        return taxShorName;
    }

    public void setTaxShorName(String taxShorName) {
        this.taxShorName = taxShorName;
    }

    public TaxNumber withZeroTax(ZeroTaxEnum zeroTax) {
        this.zeroTax = zeroTax;
        return this;
    }

    /**
    * 零税率标识
    * @return zeroTax
    **/
    @ApiModelProperty(value = "零税率标识")


    public ZeroTaxEnum getZeroTax() {
        return zeroTax;
    }

    public void setZeroTax(ZeroTaxEnum zeroTax) {
        this.zeroTax = zeroTax;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TaxNumber taxNumber = (TaxNumber) o;
        return Objects.equals(this.conversionCode, taxNumber.conversionCode) &&
            Objects.equals(this.defaultTaxCode, taxNumber.defaultTaxCode) &&
            Objects.equals(this.taxCode, taxNumber.taxCode) &&
            Objects.equals(this.taxName, taxNumber.taxName) &&
            Objects.equals(this.taxPre, taxNumber.taxPre) &&
            Objects.equals(this.taxPreCon, taxNumber.taxPreCon) &&
            Objects.equals(this.taxRate, taxNumber.taxRate) &&
            Objects.equals(this.taxShorName, taxNumber.taxShorName) &&
            Objects.equals(this.zeroTax, taxNumber.zeroTax);
    }

    @Override
    public int hashCode() {
        return Objects.hash(conversionCode, defaultTaxCode, taxCode, taxName, taxPre, taxPreCon, taxRate, taxShorName, zeroTax);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link TaxNumber }.
     */
    public static TaxNumber fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, TaxNumber.class);
    }
}

