package org.yiwan.seiya.tower.goods.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.yiwan.seiya.tower.goods.model.TaxCodeRecord;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * BaseResponseListTaxCodeRecord
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-10-24T01:49:11.929+08:00")
public class BaseResponseListTaxCodeRecord   {
    @JsonProperty("code")
    private String code = null;

    @JsonProperty("message")
    private String message = null;

    @JsonProperty("result")
    @Valid
    private List<TaxCodeRecord> result = null;

    public BaseResponseListTaxCodeRecord withCode(String code) {
        this.code = code;
        return this;
    }

    /**
    * Get code
    * @return code
    **/
    @ApiModelProperty(value = "")


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public BaseResponseListTaxCodeRecord withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
    * Get message
    * @return message
    **/
    @ApiModelProperty(value = "")


    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public BaseResponseListTaxCodeRecord withResult(List<TaxCodeRecord> result) {
        this.result = result;
        return this;
    }

    public BaseResponseListTaxCodeRecord withResultAdd(TaxCodeRecord result) {
        if (this.result == null) {
            this.result = new ArrayList<TaxCodeRecord>();
        }
        this.result.add(result);
        return this;
    }

    /**
    * Get result
    * @return result
    **/
    @ApiModelProperty(value = "")

  @Valid

    public List<TaxCodeRecord> getResult() {
        return result;
    }

    public void setResult(List<TaxCodeRecord> result) {
        this.result = result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BaseResponseListTaxCodeRecord baseResponseListTaxCodeRecord = (BaseResponseListTaxCodeRecord) o;
        return Objects.equals(this.code, baseResponseListTaxCodeRecord.code) &&
            Objects.equals(this.message, baseResponseListTaxCodeRecord.message) &&
            Objects.equals(this.result, baseResponseListTaxCodeRecord.result);
    }

    @Override
    public int hashCode() {
        return Objects.hash(code, message, result);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link BaseResponseListTaxCodeRecord }.
     */
    public static BaseResponseListTaxCodeRecord fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, BaseResponseListTaxCodeRecord.class);
    }
}

