package org.yiwan.seiya.tower.goods.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.yiwan.seiya.tower.goods.model.GoodsTypeInfo;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * CreateGoodsTypeParam
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-10-24T01:49:11.929+08:00")
public class CreateGoodsTypeParam   {
    @JsonProperty("goodsTypeInfo")
    private GoodsTypeInfo goodsTypeInfo = null;

    public CreateGoodsTypeParam withGoodsTypeInfo(GoodsTypeInfo goodsTypeInfo) {
        this.goodsTypeInfo = goodsTypeInfo;
        return this;
    }

    /**
    * 商品类型信息
    * @return goodsTypeInfo
    **/
    @ApiModelProperty(required = true, value = "商品类型信息")
  @NotNull

  @Valid

    public GoodsTypeInfo getGoodsTypeInfo() {
        return goodsTypeInfo;
    }

    public void setGoodsTypeInfo(GoodsTypeInfo goodsTypeInfo) {
        this.goodsTypeInfo = goodsTypeInfo;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CreateGoodsTypeParam createGoodsTypeParam = (CreateGoodsTypeParam) o;
        return Objects.equals(this.goodsTypeInfo, createGoodsTypeParam.goodsTypeInfo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(goodsTypeInfo);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link CreateGoodsTypeParam }.
     */
    public static CreateGoodsTypeParam fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, CreateGoodsTypeParam.class);
    }
}

