package org.yiwan.seiya.tower.goods.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * Goods
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-10-24T01:49:11.929+08:00")
public class Goods   {
    @JsonProperty("goodsName")
    private String goodsName = null;

    @JsonProperty("goodsNo")
    private String goodsNo = null;

    @JsonProperty("goodsTypeCode")
    private String goodsTypeCode = null;

    @JsonProperty("orgId")
    private String orgId = null;

    @JsonProperty("providerCompanyName")
    private String providerCompanyName = null;

    @JsonProperty("providerTenantId")
    private Long providerTenantId = null;

    @JsonProperty("providerTenantName")
    private String providerTenantName = null;

    @JsonProperty("quantityUnit")
    private String quantityUnit = null;

    @JsonProperty("specification")
    private String specification = null;

    @JsonProperty("unitPrice")
    private BigDecimal unitPrice = null;

    public Goods withGoodsName(String goodsName) {
        this.goodsName = goodsName;
        return this;
    }

    /**
    * 商品名称
    * @return goodsName
    **/
    @ApiModelProperty(required = true, value = "商品名称")
  @NotNull


    public String getGoodsName() {
        return goodsName;
    }

    public void setGoodsName(String goodsName) {
        this.goodsName = goodsName;
    }

    public Goods withGoodsNo(String goodsNo) {
        this.goodsNo = goodsNo;
        return this;
    }

    /**
    * 商品编码
    * @return goodsNo
    **/
    @ApiModelProperty(required = true, value = "商品编码")
  @NotNull


    public String getGoodsNo() {
        return goodsNo;
    }

    public void setGoodsNo(String goodsNo) {
        this.goodsNo = goodsNo;
    }

    public Goods withGoodsTypeCode(String goodsTypeCode) {
        this.goodsTypeCode = goodsTypeCode;
        return this;
    }

    /**
    * 商品类型
    * @return goodsTypeCode
    **/
    @ApiModelProperty(required = true, value = "商品类型")
  @NotNull


    public String getGoodsTypeCode() {
        return goodsTypeCode;
    }

    public void setGoodsTypeCode(String goodsTypeCode) {
        this.goodsTypeCode = goodsTypeCode;
    }

    public Goods withOrgId(String orgId) {
        this.orgId = orgId;
        return this;
    }

    /**
    * 所属组织
    * @return orgId
    **/
    @ApiModelProperty(value = "所属组织")


    public String getOrgId() {
        return orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public Goods withProviderCompanyName(String providerCompanyName) {
        this.providerCompanyName = providerCompanyName;
        return this;
    }

    /**
    * 供应商公司名称
    * @return providerCompanyName
    **/
    @ApiModelProperty(value = "供应商公司名称")


    public String getProviderCompanyName() {
        return providerCompanyName;
    }

    public void setProviderCompanyName(String providerCompanyName) {
        this.providerCompanyName = providerCompanyName;
    }

    public Goods withProviderTenantId(Long providerTenantId) {
        this.providerTenantId = providerTenantId;
        return this;
    }

    /**
    * 供应商租户id
    * @return providerTenantId
    **/
    @ApiModelProperty(value = "供应商租户id")


    public Long getProviderTenantId() {
        return providerTenantId;
    }

    public void setProviderTenantId(Long providerTenantId) {
        this.providerTenantId = providerTenantId;
    }

    public Goods withProviderTenantName(String providerTenantName) {
        this.providerTenantName = providerTenantName;
        return this;
    }

    /**
    * 供应商租户名称
    * @return providerTenantName
    **/
    @ApiModelProperty(value = "供应商租户名称")


    public String getProviderTenantName() {
        return providerTenantName;
    }

    public void setProviderTenantName(String providerTenantName) {
        this.providerTenantName = providerTenantName;
    }

    public Goods withQuantityUnit(String quantityUnit) {
        this.quantityUnit = quantityUnit;
        return this;
    }

    /**
    * 单位
    * @return quantityUnit
    **/
    @ApiModelProperty(value = "单位")


    public String getQuantityUnit() {
        return quantityUnit;
    }

    public void setQuantityUnit(String quantityUnit) {
        this.quantityUnit = quantityUnit;
    }

    public Goods withSpecification(String specification) {
        this.specification = specification;
        return this;
    }

    /**
    * 规格
    * @return specification
    **/
    @ApiModelProperty(value = "规格")


    public String getSpecification() {
        return specification;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    public Goods withUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
        return this;
    }

    /**
    * 单价
    * @return unitPrice
    **/
    @ApiModelProperty(value = "单价")

  @Valid

    public BigDecimal getUnitPrice() {
        return unitPrice;
    }

    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Goods goods = (Goods) o;
        return Objects.equals(this.goodsName, goods.goodsName) &&
            Objects.equals(this.goodsNo, goods.goodsNo) &&
            Objects.equals(this.goodsTypeCode, goods.goodsTypeCode) &&
            Objects.equals(this.orgId, goods.orgId) &&
            Objects.equals(this.providerCompanyName, goods.providerCompanyName) &&
            Objects.equals(this.providerTenantId, goods.providerTenantId) &&
            Objects.equals(this.providerTenantName, goods.providerTenantName) &&
            Objects.equals(this.quantityUnit, goods.quantityUnit) &&
            Objects.equals(this.specification, goods.specification) &&
            Objects.equals(this.unitPrice, goods.unitPrice);
    }

    @Override
    public int hashCode() {
        return Objects.hash(goodsName, goodsNo, goodsTypeCode, orgId, providerCompanyName, providerTenantId, providerTenantName, quantityUnit, specification, unitPrice);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link Goods }.
     */
    public static Goods fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, Goods.class);
    }
}

