package org.yiwan.seiya.tower.goods.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.yiwan.seiya.tower.goods.model.Goods;
import org.yiwan.seiya.tower.goods.model.TaxNumberRecord;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * GoodsDetail
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-10-24T01:49:11.929+08:00")
public class GoodsDetail   {
    @JsonProperty("goods")
    private Goods goods = null;

    @JsonProperty("mappingGoods")
    @Valid
    private List<Goods> mappingGoods = null;

    @JsonProperty("taxNumbers")
    @Valid
    private List<TaxNumberRecord> taxNumbers = null;

    public GoodsDetail withGoods(Goods goods) {
        this.goods = goods;
        return this;
    }

    /**
    * 商品信息
    * @return goods
    **/
    @ApiModelProperty(value = "商品信息")

  @Valid

    public Goods getGoods() {
        return goods;
    }

    public void setGoods(Goods goods) {
        this.goods = goods;
    }

    public GoodsDetail withMappingGoods(List<Goods> mappingGoods) {
        this.mappingGoods = mappingGoods;
        return this;
    }

    public GoodsDetail withMappingGoodsAdd(Goods mappingGoods) {
        if (this.mappingGoods == null) {
            this.mappingGoods = new ArrayList<Goods>();
        }
        this.mappingGoods.add(mappingGoods);
        return this;
    }

    /**
    * 映射商品信息
    * @return mappingGoods
    **/
    @ApiModelProperty(value = "映射商品信息")

  @Valid

    public List<Goods> getMappingGoods() {
        return mappingGoods;
    }

    public void setMappingGoods(List<Goods> mappingGoods) {
        this.mappingGoods = mappingGoods;
    }

    public GoodsDetail withTaxNumbers(List<TaxNumberRecord> taxNumbers) {
        this.taxNumbers = taxNumbers;
        return this;
    }

    public GoodsDetail withTaxNumbersAdd(TaxNumberRecord taxNumbers) {
        if (this.taxNumbers == null) {
            this.taxNumbers = new ArrayList<TaxNumberRecord>();
        }
        this.taxNumbers.add(taxNumbers);
        return this;
    }

    /**
    * 税编信息
    * @return taxNumbers
    **/
    @ApiModelProperty(value = "税编信息")

  @Valid

    public List<TaxNumberRecord> getTaxNumbers() {
        return taxNumbers;
    }

    public void setTaxNumbers(List<TaxNumberRecord> taxNumbers) {
        this.taxNumbers = taxNumbers;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        GoodsDetail goodsDetail = (GoodsDetail) o;
        return Objects.equals(this.goods, goodsDetail.goods) &&
            Objects.equals(this.mappingGoods, goodsDetail.mappingGoods) &&
            Objects.equals(this.taxNumbers, goodsDetail.taxNumbers);
    }

    @Override
    public int hashCode() {
        return Objects.hash(goods, mappingGoods, taxNumbers);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link GoodsDetail }.
     */
    public static GoodsDetail fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, GoodsDetail.class);
    }
}

