package org.yiwan.seiya.tower.goods.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * TaxCodeRecord
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-10-24T01:49:11.929+08:00")
public class TaxCodeRecord   {
    @JsonProperty("goodsTaxNo")
    private String goodsTaxNo = null;

    @JsonProperty("itemName")
    private String itemName = null;

    @JsonProperty("taxPre")
    private String taxPre = null;

    @JsonProperty("taxPreCon")
    private String taxPreCon = null;

    @JsonProperty("taxRate")
    private BigDecimal taxRate = null;

    @JsonProperty("zeroTax")
    private String zeroTax = null;

    public TaxCodeRecord withGoodsTaxNo(String goodsTaxNo) {
        this.goodsTaxNo = goodsTaxNo;
        return this;
    }

    /**
    * 税编
    * @return goodsTaxNo
    **/
    @ApiModelProperty(value = "税编")


    public String getGoodsTaxNo() {
        return goodsTaxNo;
    }

    public void setGoodsTaxNo(String goodsTaxNo) {
        this.goodsTaxNo = goodsTaxNo;
    }

    public TaxCodeRecord withItemName(String itemName) {
        this.itemName = itemName;
        return this;
    }

    /**
    * 简称
    * @return itemName
    **/
    @ApiModelProperty(value = "简称")


    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public TaxCodeRecord withTaxPre(String taxPre) {
        this.taxPre = taxPre;
        return this;
    }

    /**
    * 是否享受优惠政策, 0=否， 1=是
    * @return taxPre
    **/
    @ApiModelProperty(value = "是否享受优惠政策, 0=否， 1=是")


    public String getTaxPre() {
        return taxPre;
    }

    public void setTaxPre(String taxPre) {
        this.taxPre = taxPre;
    }

    public TaxCodeRecord withTaxPreCon(String taxPreCon) {
        this.taxPreCon = taxPreCon;
        return this;
    }

    /**
    * 优惠政策内容
    * @return taxPreCon
    **/
    @ApiModelProperty(value = "优惠政策内容")


    public String getTaxPreCon() {
        return taxPreCon;
    }

    public void setTaxPreCon(String taxPreCon) {
        this.taxPreCon = taxPreCon;
    }

    public TaxCodeRecord withTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
        return this;
    }

    /**
    * 税率
    * @return taxRate
    **/
    @ApiModelProperty(value = "税率")

  @Valid

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public TaxCodeRecord withZeroTax(String zeroTax) {
        this.zeroTax = zeroTax;
        return this;
    }

    /**
    * 零税率标识
    * @return zeroTax
    **/
    @ApiModelProperty(value = "零税率标识")


    public String getZeroTax() {
        return zeroTax;
    }

    public void setZeroTax(String zeroTax) {
        this.zeroTax = zeroTax;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TaxCodeRecord taxCodeRecord = (TaxCodeRecord) o;
        return Objects.equals(this.goodsTaxNo, taxCodeRecord.goodsTaxNo) &&
            Objects.equals(this.itemName, taxCodeRecord.itemName) &&
            Objects.equals(this.taxPre, taxCodeRecord.taxPre) &&
            Objects.equals(this.taxPreCon, taxCodeRecord.taxPreCon) &&
            Objects.equals(this.taxRate, taxCodeRecord.taxRate) &&
            Objects.equals(this.zeroTax, taxCodeRecord.zeroTax);
    }

    @Override
    public int hashCode() {
        return Objects.hash(goodsTaxNo, itemName, taxPre, taxPreCon, taxRate, zeroTax);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link TaxCodeRecord }.
     */
    public static TaxCodeRecord fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, TaxCodeRecord.class);
    }
}

