package org.yiwan.seiya.tower.goods.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * TaxNumberRecord
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-10-24T01:49:11.929+08:00")
public class TaxNumberRecord   {
    @JsonProperty("conversionCode")
    private String conversionCode = null;

  /**
   * 是否默认税编
   */
  public enum DefaultTaxCodeEnum {
    _0("0"),
    
    _1("1");

    private String value;

    DefaultTaxCodeEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static DefaultTaxCodeEnum fromValue(String text) {
      for (DefaultTaxCodeEnum b : DefaultTaxCodeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

    @JsonProperty("defaultTaxCode")
    private DefaultTaxCodeEnum defaultTaxCode = null;

    @JsonProperty("id")
    private Long id = null;

    @JsonProperty("taxCode")
    private String taxCode = null;

    @JsonProperty("taxName")
    private String taxName = null;

  /**
   * 是否享受优惠政策
   */
  public enum TaxPreEnum {
    _0("0"),
    
    _1("1");

    private String value;

    TaxPreEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static TaxPreEnum fromValue(String text) {
      for (TaxPreEnum b : TaxPreEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

    @JsonProperty("taxPre")
    private TaxPreEnum taxPre = null;

    @JsonProperty("taxPreCon")
    private String taxPreCon = null;

    @JsonProperty("taxRate")
    private BigDecimal taxRate = null;

    @JsonProperty("taxShorName")
    private String taxShorName = null;

  /**
   * 零税率标识
   */
  public enum ZeroTaxEnum {
    _0("0"),
    
    _1("1"),
    
    _2("2"),
    
    _3("3");

    private String value;

    ZeroTaxEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ZeroTaxEnum fromValue(String text) {
      for (ZeroTaxEnum b : ZeroTaxEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }
  }

    @JsonProperty("zeroTax")
    private ZeroTaxEnum zeroTax = null;

    public TaxNumberRecord withConversionCode(String conversionCode) {
        this.conversionCode = conversionCode;
        return this;
    }

    /**
    * 税编转换代码
    * @return conversionCode
    **/
    @ApiModelProperty(required = true, value = "税编转换代码")
  @NotNull


    public String getConversionCode() {
        return conversionCode;
    }

    public void setConversionCode(String conversionCode) {
        this.conversionCode = conversionCode;
    }

    public TaxNumberRecord withDefaultTaxCode(DefaultTaxCodeEnum defaultTaxCode) {
        this.defaultTaxCode = defaultTaxCode;
        return this;
    }

    /**
    * 是否默认税编
    * @return defaultTaxCode
    **/
    @ApiModelProperty(required = true, value = "是否默认税编")
  @NotNull


    public DefaultTaxCodeEnum getDefaultTaxCode() {
        return defaultTaxCode;
    }

    public void setDefaultTaxCode(DefaultTaxCodeEnum defaultTaxCode) {
        this.defaultTaxCode = defaultTaxCode;
    }

    public TaxNumberRecord withId(Long id) {
        this.id = id;
        return this;
    }

    /**
    * id
    * @return id
    **/
    @ApiModelProperty(value = "id")


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public TaxNumberRecord withTaxCode(String taxCode) {
        this.taxCode = taxCode;
        return this;
    }

    /**
    * 税收分类编码
    * @return taxCode
    **/
    @ApiModelProperty(required = true, value = "税收分类编码")
  @NotNull


    public String getTaxCode() {
        return taxCode;
    }

    public void setTaxCode(String taxCode) {
        this.taxCode = taxCode;
    }

    public TaxNumberRecord withTaxName(String taxName) {
        this.taxName = taxName;
        return this;
    }

    /**
    * 税编名称
    * @return taxName
    **/
    @ApiModelProperty(required = true, value = "税编名称")
  @NotNull


    public String getTaxName() {
        return taxName;
    }

    public void setTaxName(String taxName) {
        this.taxName = taxName;
    }

    public TaxNumberRecord withTaxPre(TaxPreEnum taxPre) {
        this.taxPre = taxPre;
        return this;
    }

    /**
    * 是否享受优惠政策
    * @return taxPre
    **/
    @ApiModelProperty(required = true, value = "是否享受优惠政策")
  @NotNull


    public TaxPreEnum getTaxPre() {
        return taxPre;
    }

    public void setTaxPre(TaxPreEnum taxPre) {
        this.taxPre = taxPre;
    }

    public TaxNumberRecord withTaxPreCon(String taxPreCon) {
        this.taxPreCon = taxPreCon;
        return this;
    }

    /**
    * 优惠政策内容
    * @return taxPreCon
    **/
    @ApiModelProperty(value = "优惠政策内容")


    public String getTaxPreCon() {
        return taxPreCon;
    }

    public void setTaxPreCon(String taxPreCon) {
        this.taxPreCon = taxPreCon;
    }

    public TaxNumberRecord withTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
        return this;
    }

    /**
    * 税率
    * @return taxRate
    **/
    @ApiModelProperty(required = true, value = "税率")
  @NotNull

  @Valid

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public TaxNumberRecord withTaxShorName(String taxShorName) {
        this.taxShorName = taxShorName;
        return this;
    }

    /**
    * 税编简称
    * @return taxShorName
    **/
    @ApiModelProperty(required = true, value = "税编简称")
  @NotNull


    public String getTaxShorName() {
        return taxShorName;
    }

    public void setTaxShorName(String taxShorName) {
        this.taxShorName = taxShorName;
    }

    public TaxNumberRecord withZeroTax(ZeroTaxEnum zeroTax) {
        this.zeroTax = zeroTax;
        return this;
    }

    /**
    * 零税率标识
    * @return zeroTax
    **/
    @ApiModelProperty(value = "零税率标识")


    public ZeroTaxEnum getZeroTax() {
        return zeroTax;
    }

    public void setZeroTax(ZeroTaxEnum zeroTax) {
        this.zeroTax = zeroTax;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TaxNumberRecord taxNumberRecord = (TaxNumberRecord) o;
        return Objects.equals(this.conversionCode, taxNumberRecord.conversionCode) &&
            Objects.equals(this.defaultTaxCode, taxNumberRecord.defaultTaxCode) &&
            Objects.equals(this.id, taxNumberRecord.id) &&
            Objects.equals(this.taxCode, taxNumberRecord.taxCode) &&
            Objects.equals(this.taxName, taxNumberRecord.taxName) &&
            Objects.equals(this.taxPre, taxNumberRecord.taxPre) &&
            Objects.equals(this.taxPreCon, taxNumberRecord.taxPreCon) &&
            Objects.equals(this.taxRate, taxNumberRecord.taxRate) &&
            Objects.equals(this.taxShorName, taxNumberRecord.taxShorName) &&
            Objects.equals(this.zeroTax, taxNumberRecord.zeroTax);
    }

    @Override
    public int hashCode() {
        return Objects.hash(conversionCode, defaultTaxCode, id, taxCode, taxName, taxPre, taxPreCon, taxRate, taxShorName, zeroTax);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link TaxNumberRecord }.
     */
    public static TaxNumberRecord fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, TaxNumberRecord.class);
    }
}

