package org.yiwan.seiya.tower.logistics.model;

import java.io.IOException;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.yiwan.seiya.tower.logistics.model.OrderBookingResponse;
import org.springframework.validation.annotation.Validated;
import javax.validation.Valid;
import javax.validation.constraints.*;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.JsonProcessingException;

/**
 * DefaultResponseOrderBookingResponse
 */
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.languages.SeiyaSpringCodegen", date = "2019-10-12T19:08:02.829+08:00")
public class DefaultResponseOrderBookingResponse   {
    @JsonProperty("code")
    private String code = null;

    @JsonProperty("message")
    private String message = null;

    @JsonProperty("result")
    private OrderBookingResponse result = null;

    public DefaultResponseOrderBookingResponse withCode(String code) {
        this.code = code;
        return this;
    }

    /**
    * 状态码
    * @return code
    **/
    @ApiModelProperty(example = "LGSTZZ0200", value = "状态码")


    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public DefaultResponseOrderBookingResponse withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
    * 状态描述
    * @return message
    **/
    @ApiModelProperty(example = "请求成功", value = "状态描述")


    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public DefaultResponseOrderBookingResponse withResult(OrderBookingResponse result) {
        this.result = result;
        return this;
    }

    /**
    * 返回数据
    * @return result
    **/
    @ApiModelProperty(value = "返回数据")

  @Valid

    public OrderBookingResponse getResult() {
        return result;
    }

    public void setResult(OrderBookingResponse result) {
        this.result = result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        DefaultResponseOrderBookingResponse defaultResponseOrderBookingResponse = (DefaultResponseOrderBookingResponse) o;
        return Objects.equals(this.code, defaultResponseOrderBookingResponse.code) &&
            Objects.equals(this.message, defaultResponseOrderBookingResponse.message) &&
            Objects.equals(this.result, defaultResponseOrderBookingResponse.result);
    }

    @Override
    public int hashCode() {
        return Objects.hash(code, message, result);
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writeValueAsString(this);
        } catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return "{}";
    }

    /**
     * Convert the given JSON string to object of class {@link DefaultResponseOrderBookingResponse }.
     */
    public static DefaultResponseOrderBookingResponse fromString(String json) throws IOException {
        return new ObjectMapper().readValue(json, DefaultResponseOrderBookingResponse.class);
    }
}

